/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessInjectionTargetObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class InjectionIntoNonContextualComponentTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionIntoNonContextualComponentTest.class)).withWebXml("web2.xml")).withExtensions(ProcessInjectionTargetObserver.class, ProcessAnnotatedTypeObserver.class)).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="ef"), @SpecAssertion(section="5.5.2", id="ae"), @SpecAssertion(section="5.5.2", id="bn"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoServlet() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=injection");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.2", id="af"), @SpecAssertion(section="5.5.2", id="bm"), @SpecAssertion(section="3.10", id="b")})
    public void testServletInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=initializer");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="eg"), @SpecAssertion(section="5.5.2", id="ag"), @SpecAssertion(section="5.5.2", id="bq"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=injection");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.2", id="ah"), @SpecAssertion(section="5.5.2", id="bp"), @SpecAssertion(section="3.10", id="b")})
    public void testFilterInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=initializer");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="ea"), @SpecAssertion(section="5.5.2", id="ai"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoServletListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=injection");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.2", id="aj"), @SpecAssertion(section="3.10", id="b")})
    public void testServletListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=initializer");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="eb"), @SpecAssertion(section="5.5.2", id="am"), @SpecAssertion(section="5.5.2", id="an"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoTagHandler() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        WebResponse response = webClient.getPage(this.contextPath + "TagPage.jsp").getWebResponse();
        assert (response.getStatusCode() == 200);
        assert (response.getContentAsString().contains("Injection works."));
        assert (response.getContentAsString().contains("Initializer works."));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="ec"), @SpecAssertion(section="5.5.2", id="as"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoTagLibraryListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=injection");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.2", id="at"), @SpecAssertion(section="3.10", id="b")})
    public void testTagLibraryListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=initializer");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="d"), @SpecAssertion(section="5.5.2", id="au"), @SpecAssertion(section="5.5.2", id="av"), @SpecAssertion(section="3.9", id="b")})
    public void testInjectionIntoJSFManagedBean() throws Exception {
        WebClient webclient = new WebClient();
        webclient.setThrowExceptionOnFailingStatusCode(true);
        String content = webclient.getPage(this.contextPath + "ManagedBeanTestPage.jsf").getWebResponse().getContentAsString();
        assert (content.contains("Injection works"));
        assert (content.contains("Initializer works"));
    }
}

