/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.Black;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWS;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWSEndPoint;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWSEndPointService;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class WebServiceResourceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(WebServiceResourceTest.class)).withWebXml("web.xml")).build();
    }

    @RunAsClient
    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="ee"), @SpecAssertion(section="5.5.2", id="aq"), @SpecAssertion(section="5.5.2", id="ar")})
    public void testInjectionIntoWebServiceEndpoint(@ArquillianResource URL contextPath) throws Exception {
        URL wsdlLocation = new URL(contextPath.toExternalForm() + "TestWebService?wsdl");
        SheepWSEndPointService service = new SheepWSEndPointService(wsdlLocation, new QName("http://ws.contextual.non.injection.lookup.tests.tck.cdi.jboss.org/", "SheepWS"));
        SheepWS ws = service.getSheepWSPort();
        Assert.assertTrue((boolean)ws.isSheepInjected());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.6.1", id="ff"), @SpecAssertion(section="3.6.2", id="ae")})
    public void testResourceBeanTypes() {
        Bean<SheepWS> sheepWsBean = this.getUniqueBean(SheepWS.class, new Annotation[0]);
        Assert.assertEquals((int)sheepWsBean.getTypes().size(), (int)3);
        this.typeSetMatches(sheepWsBean.getTypes(), new Type[]{Object.class, SheepWS.class, SheepWSEndPoint.class});
        Bean<SheepWS> blackSheepWsBean = this.getUniqueBean(SheepWS.class, new Annotation[]{new AnnotationLiteral<Black>(){}});
        Assert.assertEquals((int)blackSheepWsBean.getTypes().size(), (int)2);
        this.typeSetMatches(blackSheepWsBean.getTypes(), new Type[]{Object.class, SheepWS.class});
    }
}

