/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ActionSequence {
    private String name;
    private List<String> data = Collections.synchronizedList(new ArrayList());
    private static final String DEFAULT_SEQUENCE = "default";
    private static Map<String, ActionSequence> sequences = new HashMap<String, ActionSequence>();

    public ActionSequence() {
        this.name = DEFAULT_SEQUENCE;
    }

    public ActionSequence(String name) {
        this.name = name;
    }

    public ActionSequence add(String actionId) {
        this.data.add(actionId);
        return this;
    }

    public List<String> getData() {
        return Collections.unmodifiableList(new ArrayList<String>(this.data));
    }

    public String getName() {
        return this.name;
    }

    public boolean containsAll(String ... actions) {
        return this.getData().containsAll(Arrays.asList(actions));
    }

    public boolean beginsWith(String ... actions) {
        List<String> sequenceData = this.getData();
        List<String> matchData = Arrays.asList(actions);
        if (sequenceData.size() < matchData.size()) {
            return false;
        }
        return ((Object)sequenceData.subList(0, matchData.size())).equals(matchData);
    }

    public boolean endsWith(String ... actions) {
        List<String> sequenceData = this.getData();
        List<String> matchData = Arrays.asList(actions);
        if (sequenceData.size() < matchData.size()) {
            return false;
        }
        return ((Object)sequenceData.subList(sequenceData.size() - matchData.size(), sequenceData.size())).equals(matchData);
    }

    public String toString() {
        return String.format("ActionSequence [name=%s, data=%s]", this.name, this.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<String, ActionSequence> map = sequences;
        synchronized (map) {
            sequences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addAction(String sequenceName, String actionId) {
        boolean newSequenceAdded = false;
        Map<String, ActionSequence> map = sequences;
        synchronized (map) {
            if (!sequences.containsKey(sequenceName)) {
                sequences.put(sequenceName, new ActionSequence(sequenceName));
                newSequenceAdded = true;
            }
            sequences.get(sequenceName).add(actionId);
        }
        return newSequenceAdded;
    }

    public static boolean addAction(String actionId) {
        return ActionSequence.addAction(DEFAULT_SEQUENCE, actionId);
    }

    public static ActionSequence getSequence() {
        return ActionSequence.getSequence(DEFAULT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionSequence getSequence(String sequenceName) {
        Map<String, ActionSequence> map = sequences;
        synchronized (map) {
            return sequences.get(sequenceName);
        }
    }

    public static List<String> getSequenceData() {
        return ActionSequence.getSequenceData(DEFAULT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSequenceData(String sequenceName) {
        Map<String, ActionSequence> map = sequences;
        synchronized (map) {
            return sequences.containsKey(sequenceName) ? sequences.get(sequenceName).getData() : null;
        }
    }

    public static int getSequenceSize() {
        return ActionSequence.getSequenceSize(DEFAULT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSequenceSize(String sequenceName) {
        Map<String, ActionSequence> map = sequences;
        synchronized (map) {
            return sequences.containsKey(sequenceName) ? sequences.get(sequenceName).getData().size() : 0;
        }
    }
}

