/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ContextDestructionObserver;
import org.jboss.cdi.tck.tests.context.request.IntrospectServlet;
import org.jboss.cdi.tck.tests.context.request.IntrospectTestFilter;
import org.jboss.cdi.tck.tests.context.request.TestServletRequestListener;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withWebResource("SimplePage.html", "SimplePage.html")).build();
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="aa"), @SpecAssertion(section="6.7.1", id="ac")})
    public void testRequestScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "serviceMethodTest");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="ab"), @SpecAssertion(section="6.7.1", id="ac")})
    public void testRequestScopeActiveDuringServletFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="ba"), @SpecAssertion(section="6.7.1", id="bb"), @SpecAssertion(section="6.7.1", id="bc")})
    public void testRequestScopeIsDestroyedAfterServletRequest() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspectRequest");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspectRequest");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertNotEquals((Object)secondRequestResult.getContent().trim(), (Object)firstRequestResult.getContent().trim());
        webClient.getPage(this.contextPath + "introspectRequest?mode=collect");
        ActionSequence correctSequence = new ActionSequence().add(IntrospectServlet.class.getName()).add(IntrospectTestFilter.class.getName()).add(TestServletRequestListener.class.getName()).add(ContextDestructionObserver.class.getName());
        TextPage destroyRequestResult = (TextPage)webClient.getPage(this.contextPath + "introspectRequest?mode=verify");
        Assert.assertNotNull((Object)destroyRequestResult.getContent());
        Assert.assertEquals((String)destroyRequestResult.getContent(), (String)correctSequence.toString());
    }
}

