/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.jms;

import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.event.jms.AbstractMessageListener;
import org.jboss.cdi.tck.tests.context.request.event.jms.ApplicationScopedObserver;
import org.jboss.cdi.tck.tests.context.request.event.jms.SimpleMessageProducer;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full", "jms"})
@SpecVersion(spec="cdi", version="20091101")
public class RequestScopeEventMessageDeliveryTest
extends AbstractTest {
    @Inject
    private SimpleMessageProducer producer;
    @Inject
    private ApplicationScopedObserver observer;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestScopeEventMessageDeliveryTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="jf")})
    public void testEventsFired() throws Exception {
        AbstractMessageListener.reset();
        this.observer.reset();
        this.producer.sendTopicMessage();
        new Timer().setDelay(2000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AbstractMessageListener.getProcessedMessages() >= 1;
            }
        }).start();
        Assert.assertEquals((int)1, (int)AbstractMessageListener.getProcessedMessages());
        Assert.assertTrue((boolean)AbstractMessageListener.isInitializedEventObserver());
        new Timer().setDelay(2000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return RequestScopeEventMessageDeliveryTest.this.observer.isDestroyedCalled();
            }
        }).start();
        Assert.assertTrue((boolean)this.observer.isDestroyedCalled());
    }
}

