/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.resolution;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.resolution.Bar;
import org.jboss.cdi.tck.tests.decorators.resolution.BarDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.Baz;
import org.jboss.cdi.tck.tests.decorators.resolution.BazDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.Corge;
import org.jboss.cdi.tck.tests.decorators.resolution.CorgeDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.Cow;
import org.jboss.cdi.tck.tests.decorators.resolution.Foo;
import org.jboss.cdi.tck.tests.decorators.resolution.FooDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.FooObjectDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.FresianCow;
import org.jboss.cdi.tck.tests.decorators.resolution.Garply;
import org.jboss.cdi.tck.tests.decorators.resolution.GarplyDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.Grault;
import org.jboss.cdi.tck.tests.decorators.resolution.GraultExtendsDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.GraultSuperDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.Qux;
import org.jboss.cdi.tck.tests.decorators.resolution.QuxDecorator;
import org.jboss.cdi.tck.tests.decorators.resolution.QuxListDecorator;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DecoratorResolutionTest<T, C extends Cow, F extends FresianCow>
extends AbstractTest {
    private final TypeLiteral<Bar<T>> BAR_TYPE_VARIABLE_LITERAL = new TypeLiteral<Bar<T>>(){};
    private final TypeLiteral<Baz<T>> BAZ_TYPE_VARIABLE_LITERAL = new TypeLiteral<Baz<T>>(){};
    private final TypeLiteral<Foo<T>> FOO_TYPE_VARIABLE_LITERAL = new TypeLiteral<Foo<T>>(){};
    private final TypeLiteral<Foo<Object>> FOO_OBJECT_LITERAL = new TypeLiteral<Foo<Object>>(){};
    private final TypeLiteral<Qux<String>> QUX_STRING_LITERAL = new TypeLiteral<Qux<String>>(){};
    private final TypeLiteral<Qux<List<String>>> QUX_STRING_LIST_LITERAL = new TypeLiteral<Qux<List<String>>>(){};
    private final TypeLiteral<Grault<Integer>> GRAULT_INTEGER_LITERAL = new TypeLiteral<Grault<Integer>>(){};
    private final TypeLiteral<Corge<C, C>> CORGE_TYPE_VARIABLE_EXTENDS_COW_LITERAL = new TypeLiteral<Corge<C, C>>(){};
    private final TypeLiteral<Garply<F>> GARPLY_EXTENDS_FRESIAN_COW_LITERAL = new TypeLiteral<Garply<F>>(){};
    private final TypeLiteral<Garply<Cow>> GARPLY_COW_LITERAL = new TypeLiteral<Garply<Cow>>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DecoratorResolutionTest.class)).withBeansXml("beans.xml")).build();
    }

    private static boolean decoratorCollectionMatches(Collection<Decorator<?>> decorators, Class<?> ... types) {
        HashSet typeSet = new HashSet(Arrays.asList(types));
        for (Decorator<?> decorator : decorators) {
            typeSet.remove(decorator.getBeanClass());
        }
        return typeSet.isEmpty();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="aa")})
    public void testUnboundedTypeVariables() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.BAR_TYPE_VARIABLE_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, BarDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="ab")})
    public void testObject() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.BAZ_TYPE_VARIABLE_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, BazDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="ac")})
    public void testUnboundedTypeVariablesAndObject() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.FOO_TYPE_VARIABLE_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, FooDecorator.class, FooObjectDecorator.class));
        List decorators1 = this.getCurrentManager().resolveDecorators(Collections.singleton(this.FOO_OBJECT_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators1, FooDecorator.class, FooObjectDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="c")})
    public void testIdenticalTypeParamerters() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.QUX_STRING_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, QuxDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="d")})
    public void testNestedIdenticalTypeParamerters() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.QUX_STRING_LIST_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, QuxListDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="e")})
    public void testDelegateWildcardBeanActualType() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.GRAULT_INTEGER_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, GraultExtendsDecorator.class, GraultSuperDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="f")})
    public void testDelegateWildcardBeanTypeVariable() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.CORGE_TYPE_VARIABLE_EXTENDS_COW_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, CorgeDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="g")})
    public void testDelegateTypeVariableBeanTypeVariable() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.GARPLY_EXTENDS_FRESIAN_COW_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, GarplyDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3.1", id="h")})
    public void testDelegateTypeVariableBeanActualType() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(this.GARPLY_COW_LITERAL.getType()), new Annotation[0]);
        assert (DecoratorResolutionTest.decoratorCollectionMatches(decorators, GarplyDecorator.class));
    }
}

