/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.qualifier;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.qualifier.Barn;
import org.jboss.cdi.tck.tests.definition.qualifier.BorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.Cat;
import org.jboss.cdi.tck.tests.definition.qualifier.ChunkyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.ClippedBorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.Cod;
import org.jboss.cdi.tck.tests.definition.qualifier.DefangedTarantula;
import org.jboss.cdi.tck.tests.definition.qualifier.EnglishBorderCollie;
import org.jboss.cdi.tck.tests.definition.qualifier.HairyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.MiniatureShetlandPony;
import org.jboss.cdi.tck.tests.definition.qualifier.Order;
import org.jboss.cdi.tck.tests.definition.qualifier.ShetlandPony;
import org.jboss.cdi.tck.tests.definition.qualifier.SynchronousQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.TameLiteral;
import org.jboss.cdi.tck.tests.definition.qualifier.Tarantula;
import org.jboss.cdi.tck.tests.definition.qualifier.WhitefishQualifier;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class QualifierDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(QualifierDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3.1", id="a0"), @SpecAssertion(section="2.3.1", id="aa")})
    public void testDefaultQualifierDeclaredInJava() {
        Bean<Order> order = this.getBeans(Order.class, new Annotation[0]).iterator().next();
        assert (order.getQualifiers().size() == 2);
        assert (order.getQualifiers().contains((Object)new DefaultLiteral()));
        assert (order.getQualifiers().contains(AnyLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3.1", id="b"), @SpecAssertion(section="11.1", id="c")})
    public void testDefaultQualifierForInjectionPoint() {
        Bean<Order> order = this.getBeans(Order.class, new Annotation[0]).iterator().next();
        assert (order.getInjectionPoints().size() == 1);
        InjectionPoint injectionPoint = (InjectionPoint)order.getInjectionPoints().iterator().next();
        assert (injectionPoint.getQualifiers().contains((Object)new DefaultLiteral()));
    }

    @Test(groups={"annotationDefinition"})
    @SpecAssertion(section="2.3.2", id="ba")
    public void testQualifierDeclaresBindingAnnotation() {
        Assert.assertFalse((boolean)this.getBeans(Tarantula.class, new TameLiteral()).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3.3", id="a"), @SpecAssertion(section="3.1.3", id="be")})
    public void testQualifiersDeclaredInJava() {
        Bean<Cat> cat = this.getBeans(Cat.class, new SynchronousQualifier()).iterator().next();
        assert (cat.getQualifiers().size() == 2);
        assert (cat.getQualifiers().contains(new SynchronousQualifier()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3.3", id="d")})
    public void testMultipleQualifiers() {
        Bean<Cod> model = this.getBeans(Cod.class, new ChunkyQualifier(true), new WhitefishQualifier()).iterator().next();
        assert (model.getQualifiers().size() == 4);
    }

    @Test(groups={"injection", "producerMethod"})
    @SpecAssertion(section="2.3.5", id="a")
    public void testFieldInjectedFromProducerMethod() throws Exception {
        Bean<Barn> barnBean = this.getBeans(Barn.class, new Annotation[0]).iterator().next();
        Barn barn = (Barn)barnBean.create(this.getCurrentManager().createCreationalContext(barnBean));
        assert (barn.petSpider != null);
        assert (barn.petSpider instanceof DefangedTarantula);
    }

    @Test
    @SpecAssertion(section="4.1", id="aa")
    public void testQualifierDeclaredInheritedIsInherited() throws Exception {
        Set bindings = this.getBeans(BorderCollie.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(new HairyQualifier(false)));
        assert (bindings.contains(AnyLiteral.INSTANCE));
    }

    @Test
    @SpecAssertion(section="4.1", id="aaa")
    public void testQualifierNotDeclaredInheritedIsNotInherited() {
        Set bindings = this.getBeans(ShetlandPony.class, new Annotation[0]).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains((Object)new DefaultLiteral()));
        assert (bindings.contains(AnyLiteral.INSTANCE));
    }

    @Test
    @SpecAssertion(section="4.1", id="aa")
    public void testQualifierDeclaredInheritedIsBlockedByIntermediateClass() {
        Set bindings = this.getBeans(ClippedBorderCollie.class, new HairyQualifier(true)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        HairyQualifier hairyLiteral = new HairyQualifier(true);
        assert (bindings.contains(hairyLiteral));
        assert (bindings.contains(AnyLiteral.INSTANCE));
    }

    @Test
    @SpecAssertion(section="4.1", id="ag")
    public void testQualifierDeclaredInheritedIsIndirectlyInherited() {
        Set bindings = this.getBeans(EnglishBorderCollie.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains(new HairyQualifier(false)));
    }

    @Test
    @SpecAssertion(section="4.1", id="aga")
    public void testQualifierNotDeclaredInheritedIsNotIndirectlyInherited() {
        Set bindings = this.getBeans(MiniatureShetlandPony.class, new Annotation[0]).iterator().next().getQualifiers();
        assert (bindings.size() == 2);
        assert (bindings.contains((Object)new DefaultLiteral()));
        assert (bindings.contains(AnyLiteral.INSTANCE));
    }
}

