/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.builtin.servlet;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.builtin.servlet.LowercaseConverter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ServletContainerBuiltinBeanTest
extends AbstractTest {
    @Inject
    LowercaseConverter lowercaseConverter;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ServletContainerBuiltinBeanTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="da"), @SpecAssertion(section="3.7", id="db"), @SpecAssertion(section="3.7", id="dc")})
    public void testBuiltinBeansAvailableForInjection() {
        String result = this.lowercaseConverter.convert("Foo");
        Assert.assertEquals((String)result, (String)"foo");
        Assert.assertNotNull((Object)this.lowercaseConverter.getHttpServletRequest());
        Assert.assertNotNull((Object)this.lowercaseConverter.getHttpServletRequest().getRequestURL());
        Assert.assertNotNull((Object)this.lowercaseConverter.getHttpSession());
        Assert.assertNotNull((Object)this.lowercaseConverter.getHttpSession().getId());
        Assert.assertNotNull((Object)this.lowercaseConverter.getServletContext());
        Assert.assertTrue((this.lowercaseConverter.getServletContext().getMajorVersion() >= 2 ? 1 : 0) != 0);
    }

    @RunAsClient
    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="3.7", id="da"), @SpecAssertion(section="3.7", id="db"), @SpecAssertion(section="3.7", id="dc")})
    public void testBuiltinBeansFromClient(@ArquillianResource URL contextPath) throws Exception {
        WebClient client = new WebClient();
        TextPage requestPage = (TextPage)client.getPage(contextPath + "/convert-request?text=BaR");
        Assert.assertEquals((String)requestPage.getContent(), (String)"bar");
        TextPage sessionPage = (TextPage)client.getPage(contextPath + "/convert-session");
        Assert.assertEquals((String)sessionPage.getContent(), (String)"session");
        TextPage contextPage = (TextPage)client.getPage(contextPath + "/convert-context");
        Assert.assertEquals((String)contextPage.getContent(), (String)"servletcontext");
    }
}

