/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.remove;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.remove.DependentSessionInterface;
import org.jboss.cdi.tck.tests.implementation.enterprise.remove.SessionScopedSessionInterface;
import org.jboss.cdi.tck.tests.implementation.enterprise.remove.StateKeeper;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseBeanRemoveMethodTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanRemoveMethodTest.class)).build();
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertion(section="3.2.1", id="a")
    public void testApplicationMayCallAnyRemoveMethodOnDependentScopedSessionEnterpriseBeans() throws Exception {
        Bean bean = (Bean)this.getCurrentManager().getBeans(StateKeeper.class, new Annotation[0]).iterator().next();
        StateKeeper stateKeeper = (StateKeeper)this.getCurrentManager().getReference(bean, StateKeeper.class, this.getCurrentManager().createCreationalContext((Contextual)bean));
        stateKeeper.setRemoveCalled(false);
        DependentSessionInterface sessionBean = this.getInstanceByType(DependentSessionInterface.class, new Annotation[0]);
        sessionBean.remove();
        assert (stateKeeper.isRemoveCalled());
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertion(section="3.2.1", id="da")
    public void testApplicationMayCallRemoveMethodOnDependentScopedSessionEnterpriseBeansButNoParametersArePassed() throws Exception {
        DependentSessionInterface sessionBean = this.getInstanceByType(DependentSessionInterface.class, new Annotation[0]);
        sessionBean.anotherRemoveWithParameters("required", null);
        StateKeeper stateKeeper = this.getInstanceByType(StateKeeper.class, new Annotation[0]);
        assert (stateKeeper.isRemoveCalled());
    }

    @Test(groups={"integration", "lifecycle"}, expectedExceptions={UnsupportedOperationException.class})
    @SpecAssertion(section="3.2.1", id="b")
    public void testApplicationCannotCallRemoveMethodOnNonDependentScopedSessionEnterpriseBean() {
        SessionScopedSessionInterface sessionBean = this.getInstanceByType(SessionScopedSessionInterface.class, new Annotation[0]);
        sessionBean.remove();
        assert (false) : "Should never reach this assertion";
    }
}

