/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.lifecycle;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.MockCreationalContext;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Bream;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.CdOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Cod;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Duck;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Egg;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.EggProducer;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Farm;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.FishPond;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.FooException;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Goldfish;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Goose;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.IndirectOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Lion;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Lorry_Broken;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.MountainLion;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.NovelOrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.OrderProcessor;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.RedSnapper;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Salmon;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.ShoeFactory;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Tame;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Tuna;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.TunaFarm;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.Van_Broken;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SimpleBeanLifecycleTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanLifecycleTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.8.1", id="f"), @SpecAssertion(section="3.8.1", id="g"), @SpecAssertion(section="2.3.5", id="d")})
    public void testInjectionOfParametersIntoBeanConstructor() {
        assert (this.getBeans(FishPond.class, new Annotation[0]).size() == 1);
        FishPond fishPond = this.getInstanceByType(FishPond.class, new Annotation[0]);
        assert (fishPond.goldfish != null);
        assert (fishPond.goldfish instanceof Goldfish);
        assert (fishPond.goose != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.6.2", id="b")})
    public void testSerializeRequestScoped() throws Exception {
        Cod codInstance = this.getInstanceByType(Cod.class, new Annotation[0]);
        byte[] bytes = this.passivate(codInstance);
        Object object = this.activate(bytes);
        codInstance = (Cod)object;
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)codInstance));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.6.2", id="b")})
    public void testSerializeSessionScoped() throws Exception {
        Bream instance = this.getInstanceByType(Bream.class, new Annotation[0]);
        byte[] bytes = this.passivate(instance);
        Object object = this.activate(bytes);
        instance = (Bream)object;
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)instance));
    }

    @Test
    @SpecAssertion(section="3.8.1", id="g")
    public void testQualifierTypeAnnotatedConstructor() {
        this.getInstanceByType(Duck.class, new Annotation[0]);
        assert (Duck.constructedCorrectly);
    }

    @Test(groups={"specialization"})
    @SpecAssertions(value={@SpecAssertion(section="3.1.4", id="ac")})
    public void testSpecializedBeanExtendsManagedBean() {
        assert (MountainLion.class.getAnnotation(Specializes.class) != null);
        Bean<Lion> bean = null;
        Bean<Lion> specializedBean = null;
        for (Bean<Lion> lionBean : this.getBeans(Lion.class, TAME_LITERAL)) {
            if (lionBean.getBeanClass().equals(Lion.class)) {
                bean = lionBean;
                continue;
            }
            if (!lionBean.getBeanClass().equals(MountainLion.class)) continue;
            specializedBean = lionBean;
        }
        assert (bean == null);
        assert (specializedBean != null);
        assert (specializedBean.getBeanClass().getSuperclass().equals(Lion.class));
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.1.1", id="d"), @SpecAssertion(section="6.1.1", id="g")})
    public void testCreateReturnsSameBeanPushed() {
        MockCreationalContext creationalContext = new MockCreationalContext();
        Contextual bean = (Contextual)this.getBeans(ShoeFactory.class, new Annotation[0]).iterator().next();
        MockCreationalContext.reset();
        ShoeFactory instance = (ShoeFactory)this.getCurrentManager().getContext(Dependent.class).get(bean, creationalContext);
        if (MockCreationalContext.isPushCalled()) assert (instance == MockCreationalContext.getLastBeanPushed());
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.1", id="aa")})
    public void testBeanCreateInjectsDependenciesAndInvokesInitializerToInstantiateInstance() {
        MockCreationalContext.reset();
        MockCreationalContext creationalContext = new MockCreationalContext();
        Contextual bean = (Contextual)this.getBeans(FishPond.class, new Annotation[0]).iterator().next();
        FishPond fishPond = (FishPond)bean.create(creationalContext);
        assert (fishPond != null);
        assert (fishPond.goldfish != null);
        assert (fishPond.goldfish instanceof Goldfish);
        assert (fishPond.goose != null);
        assert (fishPond.salmon != null);
        assert (fishPond.postConstructCalled);
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="2", id="g"), @SpecAssertion(section="2.2.1", id="b"), @SpecAssertion(section="2.2.1", id="k"), @SpecAssertion(section="12.2", id="da")})
    public void testManagedBean() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        assert (this.getInstanceByType(RedSnapper.class, new Annotation[0]) instanceof RedSnapper);
        RedSnapper redSnapper = this.getInstanceByType(RedSnapper.class, new Annotation[0]);
        redSnapper.ping();
        assert (redSnapper.isTouched());
    }

    @Test(groups={"injection"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.1", id="aa"), @SpecAssertion(section="3.8.1", id="aa"), @SpecAssertion(section="2.3.4", id="a"), @SpecAssertion(section="3.9", id="a"), @SpecAssertion(section="3.9.1", id="aa"), @SpecAssertion(section="12.1", id="bca")})
    public void testCreateInjectsFieldsDeclaredInJava() {
        assert (this.getBeans(TunaFarm.class, new Annotation[0]).size() == 1);
        TunaFarm tunaFarm = this.getInstanceByType(TunaFarm.class, new Annotation[0]);
        assert (tunaFarm.tuna != null);
        assert (tunaFarm.tuna.getName().equals("Ophir"));
        assert (tunaFarm.qualifiedTuna != null);
        assert (tunaFarm.qualifiedTuna.getName().equals("qualifiedTuna"));
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="l")})
    public void testContextCreatesNewInstanceForInjection() {
        Context requestContext = this.getCurrentManager().getContext(RequestScoped.class);
        Bean<Tuna> tunaBean = this.getBeans(Tuna.class, new Annotation[0]).iterator().next();
        assert (requestContext.get(tunaBean) == null);
        TunaFarm tunaFarm = this.getInstanceByType(TunaFarm.class, new Annotation[0]);
        assert (tunaFarm.tuna != null);
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.1", id="aa"), @SpecAssertion(section="7.3.1", id="ba")})
    public void testPostConstructPreDestroy() {
        assert (this.getBeans(Farm.class, new Annotation[0]).size() == 1);
        Bean<Farm> farmBean = this.getBeans(Farm.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        Farm farm = (Farm)farmBean.create(creationalContext);
        assert (farm.founded != null);
        assert (farm.initialStaff == 20);
        assert (farm.closed == null);
        farmBean.destroy((Object)farm, creationalContext);
        assert (farm.closed != null);
        assert (farm.farmOffice.noOfStaff == 0);
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.5.3", id="a0"), @SpecAssertion(section="7.3.1", id="ba"), @SpecAssertion(section="6.5.3", id="c")})
    public void testContextualDestroyDisposesWhenNecessary() {
        Bean<Goose> gooseBean = this.getBeans(Goose.class, new Annotation[0]).iterator().next();
        CreationalContext gooseCc = this.getCurrentManager().createCreationalContext(gooseBean);
        Goose goose = (Goose)gooseBean.create(gooseCc);
        assert (!this.getCurrentConfiguration().getBeans().isProxy((Object)goose));
        assert (!EggProducer.isEggDisposed());
        assert (!Egg.isEggDestroyed());
        gooseBean.destroy((Object)goose, gooseCc);
        assert (EggProducer.isEggDisposed());
        assert (!Egg.isEggDestroyed());
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a1")})
    public void testContextualDestroyCatchesException() {
        Bean<Cod> codBean = this.getBeans(Cod.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(codBean);
        Cod codInstance = this.getInstanceByType(Cod.class, new Annotation[0]);
        codInstance.ping();
        codBean.destroy((Object)codInstance, creationalContext);
    }

    @Test(groups={"lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="5.5.3", id="a")})
    public void testDependentsDestroyedAfterPreDestroy() {
        Bean<FishPond> pondBean = this.getBeans(FishPond.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(pondBean);
        FishPond fishPond = (FishPond)pondBean.create(creationalContext);
        pondBean.destroy((Object)fishPond, creationalContext);
        assert (Salmon.isBeanDestroyed());
    }

    @Test
    @SpecAssertion(section="4.2", id="baa")
    public void testSubClassInheritsPostConstructOnSuperclass() {
        OrderProcessor.postConstructCalled = false;
        assert (this.getBeans(CdOrderProcessor.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(CdOrderProcessor.class, new Annotation[0]).order();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="4.2", id="bac")
    public void testIndirectSubClassInheritsPostConstructOnSuperclass() {
        OrderProcessor.postConstructCalled = false;
        assert (this.getBeans(IndirectOrderProcessor.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(IndirectOrderProcessor.class, new Annotation[0]).order();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="4.2", id="bba")
    public void testSubClassInheritsPreDestroyOnSuperclass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(CdOrderProcessor.class, new Annotation[0]).size() == 1);
        Bean<CdOrderProcessor> bean = this.getBeans(CdOrderProcessor.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        CdOrderProcessor instance = this.getInstanceByType(CdOrderProcessor.class, new Annotation[0]);
        bean.destroy((Object)instance, creationalContext);
        assert (OrderProcessor.preDestroyCalled);
    }

    @Test
    @SpecAssertion(section="4.2", id="bbc")
    public void testIndirectSubClassInheritsPreDestroyOnSuperclass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(IndirectOrderProcessor.class, new Annotation[0]).size() == 1);
        Bean<IndirectOrderProcessor> bean = this.getBeans(IndirectOrderProcessor.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        IndirectOrderProcessor instance = this.getInstanceByType(IndirectOrderProcessor.class, new Annotation[0]);
        bean.destroy((Object)instance, creationalContext);
        assert (OrderProcessor.preDestroyCalled);
    }

    @Test
    @SpecAssertion(section="4.2", id="baa")
    public void testSubClassDoesNotInheritPostConstructOnSuperclassBlockedByIntermediateClass() {
        assert (this.getBeans(NovelOrderProcessor.class, new Annotation[0]).size() == 1);
        OrderProcessor.postConstructCalled = false;
        this.getInstanceByType(NovelOrderProcessor.class, new Annotation[0]).order();
        assert (!OrderProcessor.postConstructCalled);
    }

    @Test
    @SpecAssertion(section="4.2", id="bba")
    public void testSubClassDoesNotInheritPreDestroyConstructOnSuperclassBlockedByIntermediateClass() {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(NovelOrderProcessor.class, new Annotation[0]).size() == 1);
        Bean<NovelOrderProcessor> bean = this.getBeans(NovelOrderProcessor.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        NovelOrderProcessor instance = this.getInstanceByType(NovelOrderProcessor.class, new Annotation[0]);
        bean.destroy((Object)instance, creationalContext);
        assert (!OrderProcessor.preDestroyCalled);
    }

    @Test(expectedExceptions={CreationException.class})
    @SpecAssertion(section="6.1", id="a0")
    public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() {
        assert (this.getBeans(Lorry_Broken.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(Lorry_Broken.class, new Annotation[0]);
    }

    @Test(expectedExceptions={FooException.class})
    @SpecAssertion(section="6.1", id="a0")
    public void testUncheckedExceptionThrownFromCreateNotWrapped() {
        assert (this.getBeans(Van_Broken.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(Van_Broken.class, new Annotation[0]);
    }
}

