/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.custom;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.custom.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.interceptors.definition.custom.SecureLiteral;
import org.jboss.cdi.tck.tests.interceptors.definition.custom.TransactionalLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class CustomInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CustomInterceptorTest.class)).withBeansXml("beans.xml")).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="fa"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomPostConstructInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.POST_CONSTRUCT, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.POST_CONSTRUCT_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.POST_CONSTRUCT_INTERCEPTOR.isInterceptsCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="fb"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomPreDestroyInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_DESTROY, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.PRE_DESTROY_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.PRE_DESTROY_INTERCEPTOR.isInterceptsCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="fc"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomPostActivateInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.POST_ACTIVATE, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.POST_ACTIVATE_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.POST_ACTIVATE_INTERCEPTOR.isInterceptsCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="fd"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomPrePassivateInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_PASSIVATE, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.PRE_PASSIVATE_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.PRE_PASSIVATE_INTERCEPTOR.isInterceptsCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="fe"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomAroundInvokeInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.AROUND_INVOKE_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.AROUND_INVOKE_INTERCEPTOR.isInterceptsCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5", id="ff"), @SpecAssertion(section="11.5.2", id="dd")})
    public void testCustomAroundTimeoutInterceptor() {
        assert (!this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_TIMEOUT, new Annotation[]{new SecureLiteral(), new TransactionalLiteral()}).isEmpty());
        assert (AfterBeanDiscoveryObserver.AROUND_TIMEOUT_INTERCEPTOR.isGetInterceptorBindingsCalled());
        assert (AfterBeanDiscoveryObserver.AROUND_TIMEOUT_INTERCEPTOR.isInterceptsCalled());
    }
}

