/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.order;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.order.AccountTransaction;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.order.AnotherInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.order.Transaction;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.order.TransactionalInterceptor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class LifecycleInterceptorOrderTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleInterceptorOrderTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{TransactionalInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertion(section="9.4", id="fa")
    public void testLifecycleCallbackInvocationOrder() {
        ActionSequence.reset();
        Bean<AccountTransaction> bean = this.getUniqueBean(AccountTransaction.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        AccountTransaction transaction = (AccountTransaction)bean.create(ctx);
        transaction.execute();
        bean.destroy((Object)transaction, ctx);
        List<String> postConstruct = ActionSequence.getSequenceData("postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)TransactionalInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Transaction.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)AccountTransaction.class.getName());
        List<String> preDestroy = ActionSequence.getSequenceData("preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)TransactionalInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Transaction.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)AccountTransaction.class.getName());
    }
}

