/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import java.util.EventListener;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Farm;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TagLibraryListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestFilter;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestServlet;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestTagHandler;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withWebXml("web.xml")).withExtensions(ProcessInjectionTargetObserver.class, ProcessAnnotatedTypeObserver.class)).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aac"), @SpecAssertion(section="11.5.8", id="abc"), @SpecAssertion(section="12.4", id="de")})
    public void testProcessInjectionTargetEventFiredForServletListener() {
        assert (ProcessInjectionTargetObserver.getListenerEvent() != null);
        this.validateServletListenerAnnotatedType((AnnotatedType<TestListener>)ProcessInjectionTargetObserver.getListenerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aad"), @SpecAssertion(section="11.5.8", id="abd"), @SpecAssertion(section="12.4", id="df")})
    public void testProcessInjectionTargetEventFiredForTagHandler() {
        assert (ProcessInjectionTargetObserver.getTagHandlerEvent() != null);
        this.validateTagHandlerAnnotatedType((AnnotatedType<TestTagHandler>)ProcessInjectionTargetObserver.getTagHandlerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aae"), @SpecAssertion(section="11.5.8", id="abe"), @SpecAssertion(section="12.4", id="dg")})
    public void testProcessInjectionTargetEventFiredForTagLibraryListener() {
        assert (ProcessInjectionTargetObserver.getTagLibraryListenerEvent() != null);
        this.validateTagLibraryListenerAnnotatedType((AnnotatedType<TagLibraryListener>)ProcessInjectionTargetObserver.getTagLibraryListenerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aah"), @SpecAssertion(section="11.5.8", id="abh"), @SpecAssertion(section="12.4", id="dj")})
    public void testProcessInjectionTargetEventFiredForServlet() {
        assert (ProcessInjectionTargetObserver.getServletEvent() != null);
        this.validateServletAnnotatedType((AnnotatedType<TestServlet>)ProcessInjectionTargetObserver.getServletEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aai"), @SpecAssertion(section="11.5.8", id="abi"), @SpecAssertion(section="12.4", id="dk")})
    public void testProcessInjectionTargetEventFiredForFilter() {
        assert (ProcessInjectionTargetObserver.getFilterEvent() != null);
        this.validateFilterAnnotatedType((AnnotatedType<TestFilter>)ProcessInjectionTargetObserver.getFilterEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="dd")
    public void testProcessInjectionTargetEventFiredForJsfManagedBean() {
        assert (ProcessInjectionTargetObserver.getJsfManagedBeanEvent() != null);
        this.validateJsfManagedBeanAnnotatedType((AnnotatedType<Farm>)ProcessInjectionTargetObserver.getJsfManagedBeanEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aas"), @SpecAssertion(section="11.5.8", id="aao"), @SpecAssertion(section="11.5.8", id="aan")})
    public void testTypeOfProcessInjectionTargetParameter() {
        assert (!ProcessInjectionTargetObserver.isStringObserved());
        assert (ProcessInjectionTargetObserver.isTagHandlerSubTypeObserved());
        assert (!ProcessInjectionTargetObserver.isTagHandlerSuperTypeObserved());
        assert (!ProcessInjectionTargetObserver.isServletSuperTypeObserved());
        assert (ProcessInjectionTargetObserver.isServletSubTypeObserved());
        assert (!ProcessInjectionTargetObserver.isListenerSuperTypeObserved());
    }

    @Test
    @SpecAssertion(section="12.4", id="be")
    public void testProcessAnnotatedTypeEventFiredForServletListener() {
        assert (ProcessAnnotatedTypeObserver.getListenerEvent() != null);
        this.validateServletListenerAnnotatedType((AnnotatedType<TestListener>)ProcessAnnotatedTypeObserver.getListenerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="bf")
    public void testProcessAnnotatedTypeEventFiredForTagHandler() {
        assert (ProcessAnnotatedTypeObserver.getTagHandlerEvent() != null);
        this.validateTagHandlerAnnotatedType((AnnotatedType<TestTagHandler>)ProcessAnnotatedTypeObserver.getTagHandlerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="bg")
    public void testProcessAnnotatedTypeEventFiredForTagLibraryListener() {
        assert (ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent() != null);
        this.validateTagLibraryListenerAnnotatedType((AnnotatedType<TagLibraryListener>)ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="bj")
    public void testProcessAnnotatedTypeEventFiredForServlet() {
        assert (ProcessAnnotatedTypeObserver.getServletEvent() != null);
        this.validateServletAnnotatedType((AnnotatedType<TestServlet>)ProcessAnnotatedTypeObserver.getServletEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="bk")
    public void testProcessAnnotatedTypeEventFiredForFilter() {
        assert (ProcessAnnotatedTypeObserver.getFilterEvent() != null);
        this.validateFilterAnnotatedType((AnnotatedType<TestFilter>)ProcessAnnotatedTypeObserver.getFilterEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="12.4", id="bd")
    public void testProcessAnnotatedTypeEventFiredForJsfManagedBean() {
        assert (ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent() != null);
        this.validateJsfManagedBeanAnnotatedType((AnnotatedType<Farm>)ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent().getAnnotatedType());
    }

    private void validateServletListenerAnnotatedType(AnnotatedType<TestListener> type) {
        assert (type.getBaseType().equals(TestListener.class));
        assert (type.getAnnotations().isEmpty());
        assert (type.getFields().size() == 2);
        assert (type.getMethods().size() == 3);
        int initializers = 0;
        for (AnnotatedMethod method : type.getMethods()) {
            assert (method.getParameters().size() == 1);
            assert (method.getBaseType().equals(Void.TYPE));
            if (!method.isAnnotationPresent(Inject.class)) continue;
            ++initializers;
        }
        assert (initializers == 1);
    }

    private void validateTagHandlerAnnotatedType(AnnotatedType<TestTagHandler> type) {
        assert (type.getBaseType().equals(TestTagHandler.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), TestTagHandler.class, SimpleTagSupport.class, SimpleTag.class, JspTag.class));
        assert (type.getAnnotations().size() == 1);
        assert (type.isAnnotationPresent(Any.class));
    }

    private void validateTagLibraryListenerAnnotatedType(AnnotatedType<TagLibraryListener> type) {
        assert (type.getBaseType().equals(TagLibraryListener.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), TagLibraryListener.class, ServletContextListener.class, EventListener.class, Object.class));
        assert (type.getFields().size() == 2);
        assert (type.getConstructors().size() == 1);
        assert (type.getMethods().size() == 3);
    }

    private void validateServletAnnotatedType(AnnotatedType<TestServlet> type) {
        assert (type.getBaseType().equals(TestServlet.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), TestServlet.class, HttpServlet.class, GenericServlet.class, Servlet.class, ServletConfig.class, Object.class));
        assert (type.getAnnotations().isEmpty());
    }

    private void validateFilterAnnotatedType(AnnotatedType<TestFilter> type) {
        assert (type.getBaseType().equals(TestFilter.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), TestFilter.class, Filter.class, Object.class));
        assert (type.getFields().size() == 4);
        assert (type.getConstructors().size() == 1);
        assert (((AnnotatedConstructor)type.getConstructors().iterator().next()).getParameters().isEmpty());
        assert (type.getMethods().size() == 4);
    }

    private void validateJsfManagedBeanAnnotatedType(AnnotatedType<Farm> type) {
        assert (type.getFields().size() == 2);
        for (AnnotatedField field : type.getFields()) {
            if (field.getJavaMember().getName().equals("sheep")) {
                assert (field.isAnnotationPresent(Inject.class));
                assert (!field.isStatic());
                continue;
            }
            if (field.getJavaMember().getName().equals("initializerCalled")) {
                assert (!field.isStatic());
                assert (field.getBaseType().equals(Boolean.TYPE));
                continue;
            }
            assert (false);
        }
        assert (type.getMethods().size() == 3);
    }
}

