/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.extensions.modules;

import static org.jboss.cdi.tck.TestGroups.INTEGRATION;
import static org.jboss.cdi.tck.cdi.Sections.PM;
import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertTrue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.modules.ModuleProcessingExtension.ProcessModuleHolder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

/**
 * <p>
 * This test was originally part of Weld test suite.
 * <p>
 * 
 * @author Jozef Hartinger
 * @author Martin Kouba
 */
@SpecVersion(spec = "cdi", version = "20091101")
public class MultiModuleProcessingTest extends AbstractTest {

    @Deployment
    public static WebArchive createTestArchive() {
        return new WebArchiveBuilder()
                .withTestClass(MultiModuleProcessingTest.class)
                .withClasses(Lion.class)
                // Tiger alternative selected
                .withBeansXml(Descriptors.create(BeansDescriptor.class).createAlternatives().clazz(Tiger.class.getName()).up())
                // Tiger alternative selected, Decorator1 and Interceptor1 enabled
                .withBeanLibrary(
                        Descriptors.create(BeansDescriptor.class).createAlternatives().clazz(Tiger.class.getName()).up()
                                .createDecorators().clazz(Decorator1.class.getName()).up().createInterceptors()
                                .clazz(Interceptor1.class.getName()).up(), Animal.class, Decorator1.class, Interceptor1.class,
                        Tiger.class, Binding.class, ModuleProcessingExtension.class)
                .withLibrary(Elephant.class, ElephantExtension.class)
                .withLibrary(ShrinkWrap.create(JavaArchive.class).addPackages(true, IOUtils.class.getPackage())).build();
    }

    @Test(groups = INTEGRATION, dataProvider = ARQUILLIAN_DATA_PROVIDER)
    @SpecAssertion(section = PM, id = "a")
    public void testProcessedModulesCount(ModuleProcessingExtension moduleProcessingExtension) {
        // WEB-INF/classes and bean library
        assertEquals(moduleProcessingExtension.getModules().size(), 2);
    }

    @Test(groups = INTEGRATION, dataProvider = ARQUILLIAN_DATA_PROVIDER)
    @SpecAssertion(section = PM, id = "cg")
    public void testInitialValues(ModuleProcessingExtension moduleProcessingExtension) {

        List<ProcessModuleHolder> modules = new ArrayList<ProcessModuleHolder>(moduleProcessingExtension.getModules());
        for (Iterator<ProcessModuleHolder> iterator = modules.iterator(); iterator.hasNext();) {

            ProcessModuleHolder module = iterator.next();

            if (!module.getInterceptors().isEmpty()) {
                // Bean library
                assertEquals(module.getAlternatives().size(), 1);
                assertEquals(module.getAlternatives().iterator().next(), Tiger.class);
                assertEquals(module.getDecorators().size(), 1);
                assertEquals(module.getDecorators().get(0), Decorator1.class);
                assertEquals(module.getInterceptors().size(), 1);
                assertEquals(module.getInterceptors().get(0), Interceptor1.class);
                iterator.remove();
            } else if (!module.getAlternatives().isEmpty()) {
                // WEB-INF/classes
                assertEquals(module.getAlternatives().size(), 1);
                assertEquals(module.getAlternatives().iterator().next(), Tiger.class);
                assertTrue(module.getInterceptors().isEmpty());
                assertTrue(module.getDecorators().isEmpty());
                iterator.remove();
            }
        }
        assertEquals(modules.size(), 0);
    }
}
