/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import org.jboss.cdi.tck.shrinkwrap.ArchiveBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.WebAppVersionType;

public class WebArchiveBuilder
extends ArchiveBuilder<WebArchiveBuilder, WebArchive> {
    public static final String DEFAULT_WAR_NAME = "test.war";
    private boolean hasDefaultEjbModuleDependency = false;
    private String beansDescriptorTargetBase = null;

    public WebArchiveBuilder withDefaultEjbModuleDependency() {
        this.hasDefaultEjbModuleDependency = true;
        return this;
    }

    public WebArchiveBuilder withBeansDescriptorTargetBase(String beansDescriptorTargetBase) {
        this.beansDescriptorTargetBase = beansDescriptorTargetBase;
        return this;
    }

    @Override
    public WebArchiveBuilder self() {
        return this;
    }

    @Override
    protected WebArchive buildInternal() {
        WebArchive webArchive = null;
        webArchive = this.getName() == null ? (WebArchive)ShrinkWrap.create(WebArchive.class) : (WebArchive)ShrinkWrap.create(WebArchive.class, (String)this.getName());
        this.processPackages(webArchive);
        this.processClasses(webArchive);
        this.processLibraries((LibraryContainer<?>)webArchive);
        this.processManifestResources((ManifestContainer<?>)webArchive);
        this.processResources((ResourceContainer<?>)webArchive);
        if (this.beansDescriptor != null) {
            webArchive.addAsWebInfResource((Asset)new StringAsset(this.beansDescriptor.exportAsString()), this.buildBeansDescriptorTargetPath(this.beansDescriptor.getDescriptorName()));
        } else if (this.beansXml != null) {
            webArchive.addAsWebInfResource(this.beansXml.getSource(), this.buildBeansDescriptorTargetPath(this.beansXml.getTarget()));
        } else {
            webArchive.addAsWebInfResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), this.buildBeansDescriptorTargetPath("beans.xml"));
        }
        if (this.webXmlDescriptor != null) {
            webArchive.setWebXML((Asset)new StringAsset(this.webXmlDescriptor.version(WebAppVersionType._3_0).exportAsString()));
        } else if (this.webXml != null) {
            webArchive.setWebXML(this.webXml.getSource());
        } else {
            webArchive.setWebXML((Asset)new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version(WebAppVersionType._3_0).exportAsString()));
        }
        if (this.persistenceDescriptor != null) {
            webArchive.addAsResource((Asset)new StringAsset(this.persistenceDescriptor.exportAsString()), "META-INF/persistence.xml");
        }
        if (this.webResources != null) {
            for (ArchiveBuilder.ResourceDescriptor resource : this.webResources) {
                if (resource.getTarget() == null) {
                    webArchive.addAsWebResource(resource.getSource());
                    continue;
                }
                webArchive.addAsWebResource(resource.getSource(), resource.getTarget());
            }
        }
        if (this.hasDefaultEjbModuleDependency) {
            webArchive.setManifest((Asset)new StringAsset(((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).addToClassPath("test-ejb.jar")).exportAsString()));
        }
        return webArchive;
    }

    private String buildBeansDescriptorTargetPath(String descriptorName) {
        if (this.beansDescriptorTargetBase == null) {
            return descriptorName;
        }
        return this.beansDescriptorTargetBase + descriptorName;
    }
}

