/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextTest.class)).withWebXml("web.xml")).withWebResource("SimplePage.html")).build();
    }

    @Test
    @SpecAssertion(section="application_context", id="aa")
    public void testApplicationScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servlet");
    }

    @Test
    @SpecAssertion(section="application_context", id="ab")
    public void testApplicationScopeActiveDuringDoFilterMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test
    @SpecAssertion(section="application_context", id="ac")
    public void testApplicationScopeActiveDuringServletContextListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servletContextListener");
    }

    @Test
    @SpecAssertion(section="application_context", id="ad")
    public void testApplicationScopeActiveDuringHttpSessionListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=httpSessionListener");
    }

    @Test
    @SpecAssertion(section="application_context", id="af")
    public void testApplicationScopeActiveDuringServletRequestListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servletRequestListener");
    }

    @Test
    @SpecAssertion(section="application_context", id="e")
    public void testApplicationContextSharedBetweenServletRequests() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        Assert.assertTrue((Double.parseDouble(firstRequestResult.getContent()) != 0.0 ? 1 : 0) != 0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertEquals((Object)Double.parseDouble(secondRequestResult.getContent()), (Object)Double.parseDouble(firstRequestResult.getContent()));
    }

    @Test
    @SpecAssertion(section="application_context", id="e")
    public void testApplicationContextSharedBetweenJaxRsRequests() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "jaxrs/application-id");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        Assert.assertTrue((Double.parseDouble(firstRequestResult.getContent()) != 0.0 ? 1 : 0) != 0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "jaxrs/application-id");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertEquals((Object)Double.parseDouble(secondRequestResult.getContent()), (Object)Double.parseDouble(firstRequestResult.getContent()));
    }
}

