/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.servlet.ServletRequestEvent;

@ApplicationScoped
public class ObservingBean {
    private final AtomicInteger initializedRequestCount = new AtomicInteger();
    private final AtomicInteger destroyedRequestCount = new AtomicInteger();

    public void observeRequestInitialized(@Observes @Initialized(value=RequestScoped.class) ServletRequestEvent event) {
        if (!"bar".equals(event.getServletRequest().getParameter("foo"))) {
            throw new IllegalArgumentException("Unknown request, parameter foo not set.");
        }
        this.initializedRequestCount.incrementAndGet();
    }

    public void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) ServletRequestEvent event) {
        this.destroyedRequestCount.incrementAndGet();
    }

    public AtomicInteger getInitializedRequestCount() {
        return this.initializedRequestCount;
    }

    public AtomicInteger getDestroyedRequestCount() {
        return this.destroyedRequestCount;
    }
}

