/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.http.session;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.AbstractDecoratorTest;
import org.jboss.cdi.tck.tests.decorators.builtin.http.session.HttpSessionDecorator1;
import org.jboss.cdi.tck.tests.decorators.builtin.http.session.HttpSessionDecorator2;
import org.jboss.cdi.tck.tests.decorators.builtin.http.session.HttpSessionObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class BuiltinHttpSessionDecoratorTest
extends AbstractDecoratorTest {
    @Inject
    HttpSession httpSession;
    @Inject
    HttpSessionObserver httpSessionObserver;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinHttpSessionDecoratorTest.class)).withClass(AbstractDecoratorTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createDecorators().clazz(new String[]{HttpSessionDecorator1.class.getName()}).clazz(new String[]{HttpSessionDecorator2.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="acj"), @SpecAssertion(section="decorator_resolution", id="aa")})
    public void testDecoratorIsResolved() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(HttpSession.class), new Annotation[0]);
        Assert.assertEquals((int)2, (int)decorators.size());
        for (Decorator decorator : decorators) {
            Assert.assertEquals((Set)decorator.getDecoratedTypes(), Collections.singleton(HttpSession.class));
            Assert.assertEquals((Object)decorator.getDelegateType(), HttpSession.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="acj")})
    public void testDecoratorIsInvoked() {
        this.httpSession.invalidate();
        Assert.assertTrue((boolean)this.httpSessionObserver.isDestroyed());
        Assert.assertTrue((boolean)this.httpSessionObserver.isDecorated());
        Assert.assertEquals((long)3L, (long)this.httpSession.getLastAccessedTime());
        Assert.assertEquals((Object)"bar", (Object)this.httpSession.getAttribute("foo"));
    }
}

