/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.definition;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.definition.AbstractFooDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.BankAccount;
import org.jboss.cdi.tck.tests.decorators.definition.Bar;
import org.jboss.cdi.tck.tests.decorators.definition.Baz;
import org.jboss.cdi.tck.tests.decorators.definition.BazDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.BazDecorator1;
import org.jboss.cdi.tck.tests.decorators.definition.Bazt;
import org.jboss.cdi.tck.tests.decorators.definition.Boo;
import org.jboss.cdi.tck.tests.decorators.definition.ChargeDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.Field;
import org.jboss.cdi.tck.tests.decorators.definition.Foo;
import org.jboss.cdi.tck.tests.decorators.definition.FooBar;
import org.jboss.cdi.tck.tests.decorators.definition.FooDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.Logger;
import org.jboss.cdi.tck.tests.decorators.definition.Meta;
import org.jboss.cdi.tck.tests.decorators.definition.MockLogger;
import org.jboss.cdi.tck.tests.decorators.definition.NonMeta;
import org.jboss.cdi.tck.tests.decorators.definition.TimestampLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DecoratorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DecoratorDefinitionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createDecorators().clazz(new String[]{BazDecorator.class.getName(), BazDecorator1.class.getName(), FooDecorator.class.getName(), TimestampLogger.class.getName(), ChargeDecorator.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="d"), @SpecAssertion(section="decorator_annotation", id="a"), @SpecAssertion(section="decorated_types", id="c"), @SpecAssertion(section="decorator_resolution", id="aa"), @SpecAssertion(section="decorator", id="a"), @SpecAssertion(section="bean_discovery", id="kc")})
    public void testDecoratorIsManagedBean() {
        List decorators = this.getCurrentManager().resolveDecorators(MockLogger.TYPES, new Annotation[0]);
        assert (decorators.size() == 1);
        boolean implementsInterface = false;
        for (Class<?> interfaze : ((Decorator)decorators.get(0)).getClass().getInterfaces()) {
            if (!Decorator.class.isAssignableFrom(interfaze)) continue;
            implementsInterface = true;
            break;
        }
        assert (implementsInterface);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="b"), @SpecAssertion(section="decorator_bean", id="c"), @SpecAssertion(section="decorator", id="b"), @SpecAssertion(section="bm_decorator_resolution", id="a"), @SpecAssertion(section="bm_decorator_resolution", id="b")})
    public void testDecoratedTypes() {
        List decorators = this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[0]);
        assert (decorators.size() == 1);
        assert (((Decorator)decorators.get(0)).getDecoratedTypes().size() == 4);
        assert (((Decorator)decorators.get(0)).getDecoratedTypes().contains(Foo.class));
        assert (((Decorator)decorators.get(0)).getDecoratedTypes().contains(Bar.class));
        assert (((Decorator)decorators.get(0)).getDecoratedTypes().contains(Baz.class));
        assert (((Decorator)decorators.get(0)).getDecoratedTypes().contains(Boo.class));
        assert (!((Decorator)decorators.get(0)).getDecoratedTypes().contains(Serializable.class));
        assert (!((Decorator)decorators.get(0)).getDecoratedTypes().contains(FooDecorator.class));
        assert (!((Decorator)decorators.get(0)).getDecoratedTypes().contains(AbstractFooDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="delegate_attribute", id="a"), @SpecAssertion(section="decorator", id="c")})
    public void testDelegateInjectionPoint() {
        List decorators = this.getCurrentManager().resolveDecorators(Logger.TYPES, new Annotation[0]);
        assert (decorators.size() == 1);
        Decorator decorator = (Decorator)decorators.get(0);
        assert (decorator.getInjectionPoints().size() == 1);
        assert (((InjectionPoint)decorator.getInjectionPoints().iterator().next()).getType().equals(Logger.class));
        assert (((InjectionPoint)decorator.getInjectionPoints().iterator().next()).getAnnotated().isAnnotationPresent(Delegate.class));
        assert (decorator.getDelegateType().equals(Logger.class));
        assert (decorator.getDelegateQualifiers().size() == 1);
        assert (this.annotationSetMatches((Set<? extends Annotation>)decorator.getDelegateQualifiers(), Default.class));
    }

    @Test
    @SpecAssertion(section="decorated_types", id="b")
    public void testDecoratorDoesNotImplementDelegateType() {
        List decorators = this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]);
        assert (decorators.size() == 2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="enabled_decorators", id="g"), @SpecAssertion(section="decorator_resolution", id="aa"), @SpecAssertion(section="bm_decorator_resolution", id="a")})
    public void testDecoratorOrdering() {
        List decorators = this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]);
        assert (decorators.size() == 2);
        assert (((Decorator)decorators.get(0)).getTypes().contains(BazDecorator.class));
        assert (((Decorator)decorators.get(1)).getTypes().contains(BazDecorator1.class));
    }

    @Test
    @SpecAssertion(section="enabled_decorators", id="ab")
    public void testNonEnabledDecoratorNotResolved() {
        List decorators = this.getCurrentManager().resolveDecorators(Field.TYPES, new Annotation[0]);
        assert (decorators.size() == 0);
    }

    @Test
    @SpecAssertion(section="decorator", id="d")
    public void testInstanceOfDecoratorForEachEnabled() {
        assert (!this.getCurrentManager().resolveDecorators(MockLogger.TYPES, new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveDecorators(Logger.TYPES, new Annotation[0]).isEmpty());
        assert (this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]).size() == 2);
        assert (this.getCurrentManager().resolveDecorators(Field.TYPES, new Annotation[0]).isEmpty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="c")
    public void testDuplicateBindingsOnResolveDecoratorsFails() {
        AnnotationLiteral<Meta> binding = new AnnotationLiteral<Meta>(){};
        this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[]{binding, binding});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="d")
    public void testNonBindingsOnResolveDecoratorsFails() {
        AnnotationLiteral<NonMeta> binding = new AnnotationLiteral<NonMeta>(){};
        this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[]{binding});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="e")
    public void testEmptyTypeSetOnResolveDecoratorsFails() {
        AnnotationLiteral<NonMeta> binding = new AnnotationLiteral<NonMeta>(){};
        this.getCurrentManager().resolveDecorators(new HashSet(), new Annotation[]{binding});
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="d"), @SpecAssertion(section="decorated_types", id="c"), @SpecAssertion(section="decorated_types", id="ca")})
    public void testAbstractDecoratorNotImplementingMethodOfDecoratedType(BankAccount account) {
        ChargeDecorator.reset();
        account.deposit(100);
        Assert.assertEquals((int)ChargeDecorator.charged, (int)0);
        account.withdraw(50);
        Assert.assertEquals((int)ChargeDecorator.charged, (int)5);
        Assert.assertEquals((int)account.getBalance(), (int)45);
    }
}

