/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Animal;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Cat;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Cute;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.ModifyingExtension;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.PersianStereotype;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class SetBeanAttributesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SetBeanAttributesTest.class)).withExtension(ModifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pba", id="bc"), @SpecAssertion(section="pba", id="c")})
    public void testBeanModified() {
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{DefaultLiteral.INSTANCE}).size(), (int)0);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{new Wild.Literal(false)}).size(), (int)0);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Wild.Literal(true)}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Cute.Literal()}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().getBeans("cat").size(), (int)1);
        Bean<Cat> bean = this.getUniqueBean(Cat.class, new Cute.Literal());
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Cat.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getStereotypes(), new Type[]{PersianStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), new Annotation[]{new Wild.Literal(true), new Cute.Literal(), AnyLiteral.INSTANCE}));
        Assert.assertEquals(ApplicationScoped.class, (Object)bean.getScope());
        Assert.assertEquals((boolean)true, (boolean)bean.isAlternative());
        Assert.assertEquals((boolean)true, (boolean)bean.isNullable());
    }
}

