/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.BarStereotype;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.Bicycle;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.BicycleExtension;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.FooQualifier;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.FooStereotype;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.ModifyingExtension;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.Vehicle;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ProcessBeanAttributesFiredForSyntheticBeanTest
extends AbstractTest {
    @Inject
    BicycleExtension bicycleExtension;
    @Inject
    ModifyingExtension modifyingExtension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProcessBeanAttributesFiredForSyntheticBeanTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Bicycle.class.getName()}).up())).withExtensions(BicycleExtension.class, ModifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_beanattributes", id="a"), @SpecAssertion(section="pba", id="aa"), @SpecAssertion(section="pba", id="bb"), @SpecAssertion(section="pba", id="bc"), @SpecAssertion(section="pat", id="bc")})
    public void testProcessBeanAttributesFired() {
        Assert.assertTrue((boolean)this.bicycleExtension.isVetoed());
        Assert.assertTrue((boolean)this.modifyingExtension.isModified());
        BeanAttributes<Bicycle> attributesBeforeRegistering = this.bicycleExtension.getBicycleAttributesBeforeRegistering();
        Assert.assertEquals((Object)attributesBeforeRegistering.getScope(), ApplicationScoped.class);
        Assert.assertTrue((boolean)this.typeSetMatches(attributesBeforeRegistering.getStereotypes(), new Type[]{FooStereotype.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributesBeforeRegistering.getTypes(), new Type[]{Object.class, Vehicle.class, Bicycle.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributesBeforeRegistering.getQualifiers(), FooQualifier.class, Any.class));
        Assert.assertFalse((boolean)attributesBeforeRegistering.isAlternative());
        Assert.assertTrue((boolean)attributesBeforeRegistering.isNullable());
        BeanAttributes<Bicycle> attributesBeforeModifying = this.modifyingExtension.getBicycleAttributesBeforeModifying();
        Assert.assertEquals((Object)attributesBeforeModifying.getScope(), ApplicationScoped.class);
        Assert.assertTrue((boolean)this.typeSetMatches(attributesBeforeModifying.getStereotypes(), new Type[]{FooStereotype.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributesBeforeModifying.getTypes(), new Type[]{Object.class, Vehicle.class, Bicycle.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributesBeforeModifying.getQualifiers(), FooQualifier.class, Any.class));
        Assert.assertFalse((boolean)attributesBeforeModifying.isAlternative());
        Assert.assertTrue((boolean)attributesBeforeModifying.isNullable());
        Set<Bean<Bicycle>> beans = this.getBeans(Bicycle.class, new Annotation[]{AnyLiteral.INSTANCE});
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean<Bicycle> bean = beans.iterator().next();
        Assert.assertEquals((Object)bean.getScope(), RequestScoped.class);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getStereotypes(), new Type[]{BarStereotype.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Bicycle.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), FooQualifier.class, Any.class));
        Assert.assertTrue((boolean)bean.isAlternative());
        Assert.assertTrue((boolean)bean.isNullable());
    }
}

