/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.modules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessModule;
import org.apache.commons.io.IOUtils;

public class ModuleProcessingExtension
implements Extension {
    private final List<ProcessModuleHolder> modules = new ArrayList<ProcessModuleHolder>();

    public void observe(@Observes ProcessModule event) {
        this.modules.add(new ProcessModuleHolder(event));
    }

    public List<ProcessModuleHolder> getModules() {
        return this.modules;
    }

    public ProcessModuleHolder getFirstModule() {
        if (this.modules == null || this.modules.isEmpty()) {
            return null;
        }
        return this.modules.iterator().next();
    }

    public static class ProcessModuleHolder {
        private final List<Class<?>> interceptors;
        private final List<Class<?>> decorators;
        private final List<Class<?>> alternatives;
        private final String beansXml;

        public ProcessModuleHolder(ProcessModule event) {
            this.interceptors = new ArrayList(event.getInterceptors());
            this.decorators = new ArrayList(event.getDecorators());
            this.alternatives = new ArrayList(event.getAlternatives());
            this.beansXml = this.readBeansXml(event);
        }

        public List<Class<?>> getInterceptors() {
            return this.interceptors;
        }

        public List<Class<?>> getDecorators() {
            return this.decorators;
        }

        public List<Class<?>> getAlternatives() {
            return this.alternatives;
        }

        public String getBeansXml() {
            return this.beansXml;
        }

        private String readBeansXml(ProcessModule event) {
            try {
                return IOUtils.toString((InputStream)event.getBeansXml());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

