/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.modules;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.modules.Animal;
import org.jboss.cdi.tck.tests.extensions.modules.Binding;
import org.jboss.cdi.tck.tests.extensions.modules.Decorator1;
import org.jboss.cdi.tck.tests.extensions.modules.Elephant;
import org.jboss.cdi.tck.tests.extensions.modules.ElephantExtension;
import org.jboss.cdi.tck.tests.extensions.modules.Interceptor1;
import org.jboss.cdi.tck.tests.extensions.modules.Lion;
import org.jboss.cdi.tck.tests.extensions.modules.ModuleProcessingExtension;
import org.jboss.cdi.tck.tests.extensions.modules.Tiger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class MultiModuleProcessingTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(MultiModuleProcessingTest.class)).withClasses(Lion.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Tiger.class.getName()}).up())).withBeanLibrary((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Tiger.class.getName()}).up()).createDecorators().clazz(new String[]{Decorator1.class.getName()}).up()).createInterceptors().clazz(new String[]{Interceptor1.class.getName()}).up(), Animal.class, Decorator1.class, Interceptor1.class, Tiger.class, Binding.class, ModuleProcessingExtension.class)).withLibrary(Elephant.class, ElephantExtension.class)).withLibrary((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new Package[]{IOUtils.class.getPackage()}))).build();
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="pm", id="a")
    public void testProcessedModulesCount(ModuleProcessingExtension moduleProcessingExtension) {
        Assert.assertEquals((int)moduleProcessingExtension.getModules().size(), (int)2);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="pm", id="cg")
    public void testInitialValues(ModuleProcessingExtension moduleProcessingExtension) {
        ArrayList<ModuleProcessingExtension.ProcessModuleHolder> modules = new ArrayList<ModuleProcessingExtension.ProcessModuleHolder>(moduleProcessingExtension.getModules());
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            ModuleProcessingExtension.ProcessModuleHolder module = (ModuleProcessingExtension.ProcessModuleHolder)iterator.next();
            if (!module.getInterceptors().isEmpty()) {
                Assert.assertEquals((int)module.getAlternatives().size(), (int)1);
                Assert.assertEquals(module.getAlternatives().iterator().next(), Tiger.class);
                Assert.assertEquals((int)module.getDecorators().size(), (int)1);
                Assert.assertEquals(module.getDecorators().get(0), Decorator1.class);
                Assert.assertEquals((int)module.getInterceptors().size(), (int)1);
                Assert.assertEquals(module.getInterceptors().get(0), Interceptor1.class);
                iterator.remove();
                continue;
            }
            if (module.getAlternatives().isEmpty()) continue;
            Assert.assertEquals((int)module.getAlternatives().size(), (int)1);
            Assert.assertEquals(module.getAlternatives().iterator().next(), Tiger.class);
            Assert.assertTrue((boolean)module.getInterceptors().isEmpty());
            Assert.assertTrue((boolean)module.getDecorators().isEmpty());
            iterator.remove();
        }
        Assert.assertEquals((int)modules.size(), (int)0);
    }
}

