/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.modules;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.modules.Animal;
import org.jboss.cdi.tck.tests.extensions.modules.Binding;
import org.jboss.cdi.tck.tests.extensions.modules.Decorator1;
import org.jboss.cdi.tck.tests.extensions.modules.Decorator2;
import org.jboss.cdi.tck.tests.extensions.modules.Decorator3;
import org.jboss.cdi.tck.tests.extensions.modules.Interceptor1;
import org.jboss.cdi.tck.tests.extensions.modules.Interceptor2;
import org.jboss.cdi.tck.tests.extensions.modules.Interceptor3;
import org.jboss.cdi.tck.tests.extensions.modules.Lion;
import org.jboss.cdi.tck.tests.extensions.modules.ModuleProcessingExtension;
import org.jboss.cdi.tck.tests.extensions.modules.SingleModuleProcessingExtension;
import org.jboss.cdi.tck.tests.extensions.modules.Tiger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SingleModuleProcessingTest
extends AbstractTest {
    private static final String BEANS_XML_TEST = "/beans.xml.test";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(SingleModuleProcessingTest.class)).withClasses(Animal.class, Binding.class, Decorator1.class, Decorator2.class, Decorator3.class, Interceptor1.class, Interceptor2.class, Interceptor3.class, Lion.class, SingleModuleProcessingExtension.class, ModuleProcessingExtension.class, Tiger.class)).withBeansXml(SingleModuleProcessingTest.getBeansDescriptor())).withExtension(SingleModuleProcessingExtension.class)).withLibrary((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new Package[]{IOUtils.class.getPackage()}))).build()).addAsResource((Asset)new StringAsset(SingleModuleProcessingTest.getBeansDescriptor().exportAsString()), BEANS_XML_TEST);
    }

    private static BeansDescriptor getBeansDescriptor() {
        return (BeansDescriptor)((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Lion.class.getName()}).up()).createDecorators().clazz(new String[]{Decorator1.class.getName(), Decorator2.class.getName()}).up()).createInterceptors().clazz(new String[]{Interceptor1.class.getName(), Interceptor2.class.getName()}).up();
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="pm", id="a")
    public void testProcessedModulesCount(SingleModuleProcessingExtension moduleProcessingExtension) {
        Assert.assertEquals((int)moduleProcessingExtension.getModules().size(), (int)1);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="pm", id="ba"), @SpecAssertion(section="pm", id="ca"), @SpecAssertion(section="pm", id="cb")})
    public void testAlternatives(SingleModuleProcessingExtension moduleProcessingExtension) {
        List<Class<?>> enabledAlternatives = moduleProcessingExtension.getFirstModule().getAlternatives();
        Assert.assertEquals((int)enabledAlternatives.size(), (int)1);
        Assert.assertTrue((boolean)enabledAlternatives.contains(Lion.class));
        Bean bean = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(Animal.class, new Annotation[0]));
        Assert.assertEquals((Object)bean.getBeanClass(), Tiger.class);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="pm", id="bc"), @SpecAssertion(section="pm", id="ce"), @SpecAssertion(section="pm", id="cf")})
    public void testDecorators(SingleModuleProcessingExtension moduleProcessingExtension) {
        List<Class<?>> enabledDecorators = moduleProcessingExtension.getFirstModule().getDecorators();
        Assert.assertEquals((int)enabledDecorators.size(), (int)2);
        Assert.assertEquals(enabledDecorators.get(0), Decorator1.class);
        Assert.assertEquals(enabledDecorators.get(1), Decorator2.class);
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(Animal.class), new Annotation[0]);
        Assert.assertEquals((int)decorators.size(), (int)2);
        Assert.assertEquals((Object)((Decorator)decorators.get(0)).getBeanClass(), Decorator1.class);
        Assert.assertEquals((Object)((Decorator)decorators.get(1)).getBeanClass(), Decorator3.class);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="pm", id="bb"), @SpecAssertion(section="pm", id="cc"), @SpecAssertion(section="pm", id="cd")})
    public void testInterceptors(SingleModuleProcessingExtension moduleProcessingExtension) {
        List<Class<?>> enabledInterceptors = moduleProcessingExtension.getFirstModule().getInterceptors();
        Assert.assertEquals((int)enabledInterceptors.size(), (int)2);
        Assert.assertEquals(enabledInterceptors.get(0), Interceptor1.class);
        Assert.assertEquals(enabledInterceptors.get(1), Interceptor2.class);
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new Binding.Literal()});
        Assert.assertEquals((int)interceptors.size(), (int)2);
        Assert.assertEquals((Object)((Interceptor)interceptors.get(0)).getBeanClass(), Interceptor3.class);
        Assert.assertEquals((Object)((Interceptor)interceptors.get(1)).getBeanClass(), Interceptor1.class);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="pm", id="be")})
    public void testBeansXml(SingleModuleProcessingExtension moduleProcessingExtension) throws Exception {
        Assert.assertEquals((String)moduleProcessingExtension.getFirstModule().getBeansXml(), (String)IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(BEANS_XML_TEST)));
    }
}

