/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Assert {
    private Assert() {
    }

    public static void assertAnnotationSetMatches(Set<? extends Annotation> annotations, Class<? extends Annotation> ... requiredAnnotationTypes) {
        if (annotations.size() != requiredAnnotationTypes.length) {
            org.testng.Assert.fail((String)("Set " + annotations.toString() + " does not match array " + Arrays.toString(requiredAnnotationTypes)));
        }
        if (annotations.isEmpty() && requiredAnnotationTypes.length == 0) {
            return;
        }
        List<Class<? extends Annotation>> requiredAnnotationTypesList = Arrays.asList(requiredAnnotationTypes);
        for (Annotation annotation : annotations) {
            if (requiredAnnotationTypesList.contains(annotation.annotationType())) continue;
            org.testng.Assert.fail((String)("Set " + annotations.toString() + " does not match array " + Arrays.toString(requiredAnnotationTypes)));
        }
    }

    public static void assertTypeSetMatches(Set<? extends Type> types, Type ... requiredTypes) {
        List<Type> requiredTypeList = Arrays.asList(requiredTypes);
        if (requiredTypes.length != types.size() || !types.containsAll(requiredTypeList)) {
            org.testng.Assert.fail((String)("Set " + types.toString() + " does not match array " + requiredTypeList.toString()));
        }
    }
}

