/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Extension;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.TestGroups;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.cdi.Sections;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.impl.ConfigurationImpl;
import org.jboss.cdi.tck.impl.MockCreationalContext;
import org.jboss.cdi.tck.impl.OldSPIBridge;
import org.jboss.cdi.tck.impl.PropertiesBasedConfigurationBuilder;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.spi.Beans;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.cdi.tck.util.annotated.AnnotatedWrapper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence20.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class ArchiveBuilder<T extends ArchiveBuilder<T, A>, A extends Archive<A>> {
    private static final Logger logger = Logger.getLogger(ArchiveBuilder.class.getName());
    private static final JavaArchive supportLibrary = ArchiveBuilder.buildSupportLibrary();
    private static final JavaArchive incontainerLibrary = ArchiveBuilder.buildIncontainerLibrary();
    private String name;
    private Boolean isAsClientMode = null;
    private boolean isTestArchive = true;
    private Class<?> testClazz = null;
    protected ResourceDescriptor beansXml = null;
    protected BeansDescriptor beansDescriptor = null;
    protected ResourceDescriptor webXml = null;
    protected WebAppDescriptor webXmlDescriptor = null;
    protected PersistenceDescriptor persistenceDescriptor = null;
    protected List<ResourceDescriptor> manifestResources = null;
    protected List<ResourceDescriptor> resources = null;
    protected List<ResourceDescriptor> webResources = null;
    protected Set<Package> packages = null;
    protected Set<Class<?>> classes = null;
    protected Set<String> excludedClasses = null;
    protected List<LibraryDescriptor> libraries = null;
    protected List<JavaArchive> shrinkWrapLibraries = null;
    protected List<ServiceProviderDescriptor> serviceProviders = null;

    public T withName(String name) {
        this.name = name;
        return this.self();
    }

    public T withBeansXml(String beansXml) {
        this.beansXml = new ResourceDescriptor(beansXml, "beans.xml");
        return this.self();
    }

    public T withBeansXml(BeansDescriptor beansDescriptor) {
        this.beansDescriptor = beansDescriptor;
        return this.self();
    }

    public T withExtension(Class<? extends Extension> extensionClass) {
        return this.withServiceProvider(new ServiceProviderDescriptor(Extension.class, extensionClass));
    }

    public T withExtensions(Class<? extends Extension> ... extensionClasses) {
        return this.withServiceProvider(new ServiceProviderDescriptor(Extension.class, extensionClasses));
    }

    public T withServiceProvider(ServiceProviderDescriptor serviceProvider) {
        if (this.serviceProviders == null) {
            this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
        }
        this.serviceProviders.add(serviceProvider);
        return this.self();
    }

    public T withClass(Class<?> clazz) {
        if (this.classes == null) {
            this.classes = new HashSet();
        }
        this.classes.add(clazz);
        return this.self();
    }

    public T withClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.withClass(clazz);
        }
        return this.self();
    }

    public T withExcludedClass(String clazz) {
        if (this.excludedClasses == null) {
            this.excludedClasses = new HashSet<String>();
        }
        this.excludedClasses.add(clazz);
        return this.self();
    }

    public T withExcludedClasses(String ... classes) {
        for (String clazz : classes) {
            this.withExcludedClass(clazz);
        }
        return this.self();
    }

    public T withTestClassPackage(Class<?> testClazz) {
        return ((ArchiveBuilder)this.withTestClassDefinition(testClazz)).withPackage(testClazz.getPackage());
    }

    public T withTestClass(Class<?> testClazz) {
        return ((ArchiveBuilder)this.withTestClassDefinition(testClazz)).withClass(testClazz);
    }

    public T withTestClassDefinition(Class<?> testClazz) {
        if (this.testClazz != null) {
            throw new IllegalStateException("Cannot set more than one test class definition!");
        }
        this.testClazz = testClazz;
        return this.self();
    }

    public T withPackage(Package pack) {
        if (this.packages == null) {
            this.packages = new HashSet<Package>();
        }
        this.packages.add(pack);
        return this.self();
    }

    public T withManifestResource(String source) {
        return this.withManifestResource(source, null, true);
    }

    public T withManifestResource(String source, boolean useTestPackageToLocateSource) {
        return this.withManifestResource(source, null, useTestPackageToLocateSource);
    }

    public T withManifestResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.manifestResources == null) {
            this.manifestResources = new ArrayList<ResourceDescriptor>();
        }
        this.manifestResources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withResource(String source) {
        return this.withResource(source, null, true);
    }

    public T withResource(String source, boolean useTestPackageToLocateSource) {
        return this.withResource(source, null, useTestPackageToLocateSource);
    }

    public T withResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceDescriptor>();
        }
        this.resources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withWebResource(String source) {
        return this.withWebResource(source, null, true);
    }

    public T withWebResource(String source, String target) {
        return this.withWebResource(source, target, true);
    }

    public T withWebResource(String source, boolean useTestPackageToLocateSource) {
        return this.withWebResource(source, null, useTestPackageToLocateSource);
    }

    public T withWebResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.webResources == null) {
            this.webResources = new ArrayList<ResourceDescriptor>();
        }
        this.webResources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withEjbJarXml(String ejbJarXml) {
        return this.withManifestResource(ejbJarXml, "ejb-jar.xml", true);
    }

    public T withWebXml(String webXml) {
        this.webXml = new ResourceDescriptor(webXml);
        return this.self();
    }

    public T withWebXml(WebAppDescriptor webXml) {
        this.webXmlDescriptor = webXml;
        return this.self();
    }

    public T withDefaultPersistenceXml() {
        return this.withPersistenceXml((PersistenceDescriptor)((PersistenceDescriptor)Descriptors.create(PersistenceDescriptor.class)).createPersistenceUnit().name("test").jtaDataSource(ConfigurationFactory.get().getTestDataSource()).up());
    }

    public T withPersistenceXml(PersistenceDescriptor persistenceDescriptor) {
        this.persistenceDescriptor = persistenceDescriptor;
        return this.self();
    }

    public T withLibrary(File library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<LibraryDescriptor>();
        }
        this.libraries.add(new LibraryDescriptor(library));
        return this.self();
    }

    public T withBeanLibrary(Class<?> ... beanClasses) {
        return this.withLibrary(null, true, beanClasses);
    }

    public T withBeanLibrary(BeansDescriptor beansDescriptor, Class<?> ... beanClasses) {
        return this.withBeanLibrary(null, beansDescriptor, beanClasses);
    }

    public T withBeanLibrary(String name, Class<?> ... beanClasses) {
        return this.withBeanLibrary(name, (BeansDescriptor)null, beanClasses);
    }

    public T withBeanLibrary(String name, BeansDescriptor beansDescriptor, Class<?> ... beanClasses) {
        return this.withLibrary(name, beansDescriptor, true, beanClasses);
    }

    public T withLibrary(Class<?> ... classes) {
        return this.withLibrary(null, false, classes);
    }

    public T withLibrary(BeansDescriptor beansDescriptor, boolean includeEmptyBeanXml, Class<?> ... classes) {
        return this.withLibrary(null, beansDescriptor, includeEmptyBeanXml, classes);
    }

    public T withLibrary(String name, BeansDescriptor beansDescriptor, boolean includeEmptyBeanXml, Class<?> ... classes) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<LibraryDescriptor>(5);
        }
        ArrayList extensions = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!Extension.class.isAssignableFrom(clazz)) continue;
            extensions.add(clazz);
        }
        ServiceProviderDescriptor serviceProvider = extensions.isEmpty() ? null : new ServiceProviderDescriptor(Extension.class, extensions.toArray(new Class[extensions.size()]));
        this.libraries.add(beansDescriptor != null ? new LibraryDescriptor(name, serviceProvider, beansDescriptor, classes) : new LibraryDescriptor(name, serviceProvider, includeEmptyBeanXml, classes));
        return this.self();
    }

    public T withLibrary(JavaArchive library) {
        if (this.shrinkWrapLibraries == null) {
            this.shrinkWrapLibraries = new ArrayList<JavaArchive>(5);
        }
        this.shrinkWrapLibraries.add(library);
        return this.self();
    }

    public abstract T self();

    public A build() {
        long start = System.currentTimeMillis();
        if (this.isTestArchive()) {
            if (this.testClazz == null) {
                throw new IllegalStateException("Test class must be set!");
            }
            this.resolveAsClientMode();
            this.withLibrary(supportLibrary);
            this.addDefaultLibraries();
            if (!this.isAsClientMode().booleanValue()) {
                this.withLibrary(incontainerLibrary);
            }
        }
        A archive = this.buildInternal();
        logger.log(Level.INFO, "Test archive built [info: {0}, time: {1} ms]", new Object[]{this.testClazz != null ? this.testClazz.getName() : archive.getName(), System.currentTimeMillis() - start});
        return archive;
    }

    protected abstract A buildInternal();

    protected <P extends Archive<?> & ClassContainer<?>> void processPackages(P archive) {
        if (this.packages == null) {
            return;
        }
        if ((this.excludedClasses == null || this.excludedClasses.isEmpty()) && !this.isAsClientMode().booleanValue()) {
            ((ClassContainer<?>)archive).addPackages(false, this.packages.toArray(new Package[this.packages.size()]));
        } else {
            final String testClazzName = this.testClazz.getName();
            ClassLoader cl = this.testClazz.getClassLoader();
            ClassLoader clToUse = cl != null ? cl : ClassLoader.getSystemClassLoader();
            URLPackageScanner.Callback callback = new URLPackageScanner.Callback((Archive)archive, clToUse){
                final /* synthetic */ Archive val$archive;
                final /* synthetic */ ClassLoader val$clToUse;
                {
                    this.val$archive = archive;
                    this.val$clToUse = classLoader;
                }

                public void classFound(String className) {
                    ArchivePath classesPath;
                    if (ArchiveBuilder.this.isAsClientMode().booleanValue() && testClazzName.equals(className)) {
                        return;
                    }
                    if (ArchiveBuilder.this.excludedClasses != null && !ArchiveBuilder.this.excludedClasses.isEmpty()) {
                        for (String exludeClassName : ArchiveBuilder.this.excludedClasses) {
                            if (!className.startsWith(exludeClassName)) continue;
                            return;
                        }
                    }
                    if ((classesPath = ArchiveBuilder.this.resolveClassesPath(this.val$archive)) != null) {
                        ArchivePath classNamePath = AssetUtil.getFullPathForClassResource((String)className);
                        this.val$archive.add((Asset)new ClassLoaderAsset(classNamePath.get().substring(1), this.val$clToUse), (ArchivePath)new BasicPath(classesPath, classNamePath));
                    } else {
                        ((ClassContainer)this.val$archive).addClass(className);
                    }
                }
            };
            for (Package pack : this.packages) {
                URLPackageScanner.newInstance((boolean)false, (ClassLoader)clToUse, (URLPackageScanner.Callback)callback, (String)pack.getName()).scanPackage();
            }
        }
    }

    protected <P extends Archive<?> & ClassContainer<?>> void processClasses(P archive) {
        if (this.classes == null || this.classes.isEmpty()) {
            return;
        }
        if (this.isSinglePackage(this.classes)) {
            Package classesPackage = null;
            final ArrayList<String> simpleNames = new ArrayList<String>(this.classes.size());
            for (Class<?> clazz : this.classes) {
                if (this.skipClassName(clazz.getName())) continue;
                simpleNames.add(clazz.getSimpleName());
                if (classesPackage == null) {
                    classesPackage = clazz.getPackage();
                }
                ClassAsset resource = new ClassAsset(clazz);
                BasicPath location = new BasicPath(this.resolveClassesPath(archive), AssetUtil.getFullPathForClassResource(clazz));
                archive.add((Asset)resource, (ArchivePath)location);
            }
            ((ClassContainer<?>)archive).addPackages(false, (Filter)new Filter<ArchivePath>(){

                public boolean include(ArchivePath path) {
                    String pathStr = path.get();
                    for (String simpleName : simpleNames) {
                        if (!pathStr.contains(simpleName)) continue;
                        return pathStr.matches(".*\\$.+\\.class");
                    }
                    return false;
                }
            }, new Package[]{classesPackage});
        } else {
            for (Class<?> clazz : this.classes) {
                if (this.skipClassName(clazz.getName())) continue;
                ((ClassContainer<?>)archive).addClass(clazz);
            }
        }
    }

    private boolean skipClassName(String className) {
        return this.isAsClientMode() != false && this.testClazz.getName().equals(className) || this.excludedClasses != null && this.excludedClasses.contains(className);
    }

    private boolean isSinglePackage(Set<Class<?>> classes) {
        String packageName = null;
        for (Class<?> clazz : classes) {
            if (packageName == null) {
                packageName = this.getPackageName(clazz);
                continue;
            }
            if (packageName.equals(this.getPackageName(clazz))) continue;
            return false;
        }
        return true;
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage() != null ? clazz.getPackage().getName() : "";
    }

    protected void processLibraries(LibraryContainer<?> archive) {
        if (this.libraries != null) {
            for (LibraryDescriptor descriptor : this.libraries) {
                if (descriptor.getFileDescriptor() != null) {
                    archive.addAsLibrary(descriptor.getFileDescriptor());
                    continue;
                }
                archive.addAsLibrary((Archive)descriptor.buildJarArchive());
            }
        }
        if (this.shrinkWrapLibraries != null) {
            archive.addAsLibraries(this.shrinkWrapLibraries);
        }
    }

    protected void processResources(ResourceContainer<?> archive) {
        if (this.resources == null) {
            return;
        }
        for (ResourceDescriptor resource : this.resources) {
            if (resource.getTarget() == null) {
                archive.addAsResource(resource.getSource());
                continue;
            }
            archive.addAsResource(resource.getSource(), resource.getTarget());
        }
    }

    protected void processManifestResources(ManifestContainer<?> archive) {
        if (this.manifestResources != null) {
            for (ResourceDescriptor resource : this.manifestResources) {
                if (resource.getTarget() == null) {
                    archive.addAsManifestResource(resource.getSource());
                    continue;
                }
                archive.addAsManifestResource(resource.getSource(), resource.getTarget());
            }
        }
        if (this.serviceProviders != null) {
            for (ServiceProviderDescriptor descriptor : this.serviceProviders) {
                archive.addAsServiceProvider(descriptor.getServiceInterface(), (Class[])descriptor.getServiceImplementations());
            }
        }
    }

    private void addDefaultLibraries() {
        File directory = new File(ConfigurationFactory.get(true).getLibraryDirectory());
        logger.log(Level.FINE, "Scanning default library dir {0}", directory.getPath());
        if (directory.isDirectory()) {
            for (File file : directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                logger.log(Level.FINE, "Adding default library {0}", file.getName());
                this.withLibrary(file);
            }
        }
    }

    private String getTestPackagePath() {
        return this.testClazz.getPackage().getName().replace('.', '/').concat("/");
    }

    public Boolean isAsClientMode() {
        return this.isAsClientMode != null ? this.isAsClientMode : false;
    }

    public T setAsClientMode(boolean isAsClientMode) {
        this.isAsClientMode = isAsClientMode;
        return this.self();
    }

    public boolean isTestArchive() {
        return this.isTestArchive;
    }

    public T notTestArchive() {
        this.isTestArchive = false;
        return this.self();
    }

    private void resolveAsClientMode() {
        if (this.isAsClientMode != null) {
            return;
        }
        if (this.testClazz.isAnnotationPresent(RunAsClient.class)) {
            this.setAsClientMode(true);
        }
        Method deploymentMethod = null;
        for (Method method : this.testClazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(Deployment.class)) continue;
            if (deploymentMethod != null && this.isAsClientMode == null) {
                throw new IllegalStateException("Multi-deployment test class and as-client mode not set");
            }
            deploymentMethod = method;
            if (!method.isAnnotationPresent(ShouldThrowException.class) && method.getAnnotation(Deployment.class).testable()) continue;
            this.setAsClientMode(true);
        }
    }

    public String getName() {
        return this.name;
    }

    private static JavaArchive buildSupportLibrary() {
        long start = System.currentTimeMillis();
        JavaArchive supportLib = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cdi-tck-support.jar")).addAsResource("META-INF/cdi-tck.properties")).addPackage(Configuration.class.getPackage())).addPackage(Beans.class.getPackage())).addClasses(new Class[]{ConfigurationFactory.class, ConfigurationImpl.class, PropertiesBasedConfigurationBuilder.class, MockCreationalContext.class, OldSPIBridge.class})).addPackage(AnyLiteral.class.getPackage())).addPackage(Timer.class.getPackage())).addPackage(AnnotatedWrapper.class.getPackage());
        logger.log(Level.INFO, "Support library built [time: {0} ms]", System.currentTimeMillis() - start);
        return supportLib;
    }

    private static JavaArchive buildIncontainerLibrary() {
        long start = System.currentTimeMillis();
        JavaArchive supportLib = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cdi-tck-incontainer.jar")).addClasses(new Class[]{AbstractTest.class, Sections.class, TestGroups.class});
        logger.log(Level.INFO, "Incontainer library built [time: {0} ms]", System.currentTimeMillis() - start);
        return supportLib;
    }

    private ArchivePath resolveClassesPath(Archive<?> archive) {
        if (archive instanceof WebArchive) {
            return ArchivePaths.create((String)"WEB-INF/classes");
        }
        if (archive instanceof JavaArchive) {
            return new BasicPath("/");
        }
        return null;
    }

    protected class LibraryDescriptor {
        private String name;
        private File fileDescriptor = null;
        private List<Class<?>> libraryClasses = null;
        protected BeansDescriptor beansDescriptor = null;
        private boolean includeEmptyBeanXml = false;
        private List<ServiceProviderDescriptor> serviceProviders;

        public LibraryDescriptor(File fileDescriptor) {
            this.fileDescriptor = fileDescriptor;
        }

        public LibraryDescriptor(String name, ServiceProviderDescriptor serviceProvider, BeansDescriptor beansDescriptor, Class<?> ... classes) {
            if (serviceProvider != null) {
                this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
                this.serviceProviders.add(serviceProvider);
            }
            this.beansDescriptor = beansDescriptor;
            this.libraryClasses = Arrays.asList(classes);
            this.name = name;
        }

        public LibraryDescriptor(String name, ServiceProviderDescriptor serviceProvider, boolean includeEmptyBeanXml, Class<?> ... classes) {
            if (serviceProvider != null) {
                this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
                this.serviceProviders.add(serviceProvider);
            }
            this.includeEmptyBeanXml = includeEmptyBeanXml;
            this.libraryClasses = Arrays.asList(classes);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Class<?>> getBeanClasses() {
            return this.libraryClasses;
        }

        public ResourceDescriptor getBeansXml() {
            return ArchiveBuilder.this.beansXml;
        }

        public boolean isOmitBeanXml() {
            return this.includeEmptyBeanXml;
        }

        public File getFileDescriptor() {
            return this.fileDescriptor;
        }

        public List<ServiceProviderDescriptor> getServiceProviders() {
            return this.serviceProviders;
        }

        public JavaArchive buildJarArchive() {
            JavaArchive library = null;
            library = this.name != null ? (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)this.name) : (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            for (Class<?> clazz : this.libraryClasses) {
                library.addClass(clazz);
            }
            if (this.serviceProviders != null) {
                for (ServiceProviderDescriptor serviceProvider : this.serviceProviders) {
                    library.addAsServiceProvider(serviceProvider.getServiceInterface(), (Class[])serviceProvider.getServiceImplementations());
                }
            }
            if (this.beansDescriptor != null) {
                library.addAsManifestResource((Asset)new StringAsset(this.beansDescriptor.exportAsString()), this.beansDescriptor.getDescriptorName());
            } else if (this.includeEmptyBeanXml) {
                library.addAsManifestResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"));
            }
            return library;
        }
    }

    protected class ResourceDescriptor {
        private String source;
        private String target;
        private boolean useTestPackageToLocateSource = true;

        public ResourceDescriptor(String source) {
            this.source = source;
        }

        public ResourceDescriptor(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public ResourceDescriptor(String source, String target, boolean useTestPackageToLocateSource) {
            this.source = source;
            this.target = target;
            this.useTestPackageToLocateSource = useTestPackageToLocateSource;
        }

        public String getSource() {
            return this.useTestPackageToLocateSource ? ArchiveBuilder.this.getTestPackagePath() + this.source : this.source;
        }

        public String getPlainSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    protected class ServiceProviderDescriptor {
        private Class<?> serviceInterface;
        private Class<?>[] serviceImplementations;

        public ServiceProviderDescriptor(Class<?> serviceInterface, Class<?> ... serviceImplementations) {
            this.serviceInterface = serviceInterface;
            this.serviceImplementations = serviceImplementations;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public Class<?>[] getServiceImplementations() {
            return this.serviceImplementations;
        }
    }
}

