/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap.descriptors;

public class BeansXmlClass {
    private final Class<?> javaClass;
    private final Boolean enabled;
    private final Integer priority;

    public BeansXmlClass(Class<?> javaClass, Boolean enabled, Integer priority) {
        if (javaClass == null) {
            throw new NullPointerException();
        }
        this.javaClass = javaClass;
        this.enabled = enabled;
        this.priority = priority;
    }

    public BeansXmlClass(Class<?> javaClass) {
        this(javaClass, null, null);
    }

    public BeansXmlClass(Class<?> javaClass, Boolean enabled) {
        this(javaClass, enabled, null);
    }

    public BeansXmlClass(Class<?> javaClass, Integer priority) {
        this(javaClass, null, priority);
    }

    public String asXmlElement() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.getElementName());
        if (this.priority != null) {
            builder.append(" ");
            builder.append("priority=\"");
            builder.append(this.priority);
            builder.append("\"");
        }
        if (this.enabled != null) {
            builder.append(" ");
            builder.append("enabled=\"");
            builder.append(this.enabled);
            builder.append("\"");
        }
        builder.append(">");
        builder.append(this.javaClass.getName());
        builder.append("</");
        builder.append(this.getElementName());
        builder.append(">");
        return builder.toString();
    }

    protected String getElementName() {
        return "class";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BeansXmlClass)) {
            return false;
        }
        BeansXmlClass other = (BeansXmlClass)obj;
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
    }
}

