/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.application.async.SimpleApplicationBean;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleAsyncListener
implements AsyncListener {
    public static Long onStartAsync = null;
    public static Long onError = null;
    public static Long onTimeout = null;
    public static Long onComplete = null;
    public static boolean isApplicationContextActive = false;
    public static boolean isSimpleApplicationBeanAvailable = false;
    private static final SimpleLogger logger = new SimpleLogger(SimpleAsyncListener.class);
    @Inject
    SimpleApplicationBean simpleApplicationBean;
    @Inject
    BeanManager beanManager;

    public void onComplete(AsyncEvent event) throws IOException {
        logger.log("onComplete", new Object[0]);
        onComplete = System.currentTimeMillis();
        if (onTimeout == null && onError == null) {
            this.checkApplicationContextAvailability(event);
            this.writeInfo(event.getAsyncContext().getResponse());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        logger.log("onTimeout", new Object[0]);
        onTimeout = System.currentTimeMillis();
        this.checkApplicationContextAvailability(event);
        this.writeInfo(event.getAsyncContext().getResponse());
        event.getAsyncContext().complete();
    }

    public void onError(AsyncEvent event) throws IOException {
        logger.log("onError", new Object[0]);
        onError = System.currentTimeMillis();
        if (this.checkApplicationContextAvailability(event)) {
            event.getAsyncContext().complete();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        logger.log("onStartAsync", new Object[0]);
        onStartAsync = System.currentTimeMillis();
        this.checkApplicationContextAvailability(event);
    }

    private boolean checkApplicationContextAvailability(AsyncEvent event) throws IOException {
        try {
            isSimpleApplicationBeanAvailable = this.simpleApplicationBean.ping();
            isApplicationContextActive = this.beanManager.getContext(ApplicationScoped.class).isActive();
        }
        catch (Throwable e) {
            logger.log("Problem while checking application scope: " + e.getMessage(), new Object[0]);
        }
        if (!isApplicationContextActive || !isSimpleApplicationBeanAvailable) {
            ((HttpServletResponse)event.getAsyncContext().getResponse()).setStatus(500);
            return false;
        }
        return true;
    }

    public static void reset() {
        onStartAsync = null;
        onError = null;
        onTimeout = null;
        onComplete = null;
        isApplicationContextActive = false;
        isSimpleApplicationBeanAvailable = false;
    }

    private void writeInfo(ServletResponse response) throws IOException {
        response.getWriter().print(SimpleAsyncListener.getInfo());
        response.getWriter().flush();
    }

    public static String getInfo() {
        return String.format("onStartAsync: %s, onError: %s, onTimeout: %s, onComplete: %s, isApplicationContextActive: %s, isSimpleApplicationBeanAvailable: %s", onStartAsync, onError, onTimeout, onComplete, isApplicationContextActive, isSimpleApplicationBeanAvailable);
    }
}

