/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.interceptor;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.interceptor.Foo;
import org.jboss.cdi.tck.tests.decorators.interceptor.FooDecorator1;
import org.jboss.cdi.tck.tests.decorators.interceptor.FooDecorator2;
import org.jboss.cdi.tck.tests.decorators.interceptor.FooInterceptor1;
import org.jboss.cdi.tck.tests.decorators.interceptor.FooInterceptor2;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DecoratorAndInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DecoratorAndInterceptorTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{FooInterceptor1.class.getName(), FooInterceptor2.class.getName()}).up()).createDecorators().clazz(new String[]{FooDecorator1.class.getName(), FooDecorator2.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="enabled_decorators", id="i"), @SpecAssertion(section="enabled_interceptors", id="g"), @SpecAssertion(section="biz_method", id="ka"), @SpecAssertion(section="biz_method", id="kb"), @SpecAssertion(section="biz_method", id="kc"), @SpecAssertion(section="biz_method", id="kd")})
    public void testMethodCallbacks() {
        ActionSequence.reset();
        this.useFoo();
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)4);
        Assert.assertEquals((String)sequence.get(0), (String)FooInterceptor1.NAME);
        Assert.assertEquals((String)sequence.get(1), (String)FooInterceptor2.NAME);
        Assert.assertEquals((String)sequence.get(2), (String)FooDecorator1.NAME);
        Assert.assertEquals((String)sequence.get(3), (String)FooDecorator2.NAME);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method", id="kc"), @SpecAssertion(section="biz_method", id="kd")})
    public void testLifecycleCallbacks() {
        ActionSequence.reset();
        String fooClass = this.useFoo();
        List<String> postConstruct = ActionSequence.getSequenceData("postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)2);
        Assert.assertEquals((String)postConstruct.get(0), (String)(fooClass + FooInterceptor1.NAME));
        Assert.assertEquals((String)postConstruct.get(1), (String)(fooClass + FooInterceptor2.NAME));
        List<String> preDestroy = ActionSequence.getSequenceData("preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)2);
        Assert.assertEquals((String)preDestroy.get(0), (String)(fooClass + FooInterceptor1.NAME));
        Assert.assertEquals((String)preDestroy.get(1), (String)(fooClass + FooInterceptor2.NAME));
    }

    private String useFoo() {
        String fooClass = null;
        Bean<Foo> bean = this.getUniqueBean(Foo.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Foo foo = (Foo)bean.create(ctx);
        fooClass = foo.getClass().getName();
        foo.doSomething();
        bean.destroy((Object)foo, ctx);
        return fooClass;
    }
}

