/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;

public class TestServlet
extends HttpServlet {
    @Inject
    private Sheep sheep;
    private boolean injectionPerformedCorrectly = false;
    private boolean initializerCalled = false;
    private boolean initCalledAfterInitializer = false;
    private static final long serialVersionUID = -7672096092047821010L;

    @Inject
    public void initialize(Sheep sheep) {
        this.initializerCalled = sheep != null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().endsWith("Servlet")) {
            this.testServlet(req, resp);
        } else if (req.getRequestURI().endsWith("ServletListener")) {
            this.testListener(req, resp);
        } else if (req.getRequestURI().endsWith("TagLibraryListener")) {
            this.testTagLibraryListener(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    private void testServlet(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            resp.setStatus(this.injectionPerformedCorrectly ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            resp.setStatus(this.initCalledAfterInitializer ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    private void testListener(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("listener.injected");
            resp.setStatus(result ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("listener.initializer.called");
            resp.setStatus(result ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    private void testTagLibraryListener(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("tag.library.listener.injected");
            resp.setStatus(result ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("tag.library.listener.initializer.called");
            resp.setStatus(result ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    public void init() throws ServletException {
        this.injectionPerformedCorrectly = this.sheep != null;
        this.initCalledAfterInitializer = this.initializerCalled;
    }

    public void init(ServletConfig config) throws ServletException {
        this.init();
    }
}

