/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationImpl;
import org.jboss.cdi.tck.spi.Beans;
import org.jboss.cdi.tck.spi.Contexts;
import org.jboss.cdi.tck.spi.EL;
import org.jboss.cdi.tck.spi.Managers;

public class PropertiesBasedConfigurationBuilder {
    public static final String RESOURCE_BUNDLE = "META-INF/cdi-tck.properties";
    private final Configuration configuration = new ConfigurationImpl();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PropertiesBasedConfigurationBuilder init(boolean deploymentPhase) {
        this.configuration.setBeans(this.getInstanceValue(Beans.PROPERTY_NAME, Beans.class, !deploymentPhase));
        this.configuration.setManagers(this.getInstanceValue(Managers.PROPERTY_NAME, Managers.class, !deploymentPhase));
        this.configuration.setEl(this.getInstanceValue(EL.PROPERTY_NAME, EL.class, !deploymentPhase));
        this.configuration.setContexts(this.getInstanceValue(Contexts.PROPERTY_NAME, Contexts.class, !deploymentPhase));
        this.configuration.setLibraryDirectory(this.getStringValue("org.jboss.cdi.tck.libraryDirectory", null, deploymentPhase));
        this.configuration.setTestDataSource(this.getStringValue("org.jboss.cdi.tck.testDataSource", null, deploymentPhase));
        return this;
    }

    public Set<String> getPropertyValues(String key) {
        HashSet<String> values = new HashSet<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    public String getStringValue(String propertyName, String defaultValue, boolean required) {
        Set<String> values = this.getPropertyValues(propertyName);
        if (values.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find required property " + propertyName + ", check that it is specified");
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value given for " + propertyName + ", not sure which one to use!");
        }
        return values.iterator().next();
    }

    private void addPropertiesFromSystem(String key, Set<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromResourceBundle(String key, Set<String> values) {
        try {
            Enumeration<URL> e = this.getResources(RESOURCE_BUNDLE);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, Set<String> values) {
        if (value != null) {
            values.add(value);
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResources(name);
        }
        return this.getClass().getClassLoader().getResources(name);
    }

    protected <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required) {
        T instance = null;
        Class<T> clazz = this.getClassValue(propertyName, expectedType, required);
        if (clazz != null) {
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
        }
        return instance;
    }

    protected <T> Class<T> getClassValue(String propertyName, Class<T> expectedType, boolean required) {
        HashSet classes = new HashSet();
        for (String className : this.getPropertyValues(propertyName)) {
            try {
                if (Thread.currentThread().getContextClassLoader() != null) {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                    continue;
                }
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Implementation class not found");
            }
        }
        if (classes.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find any implementations of " + expectedType.getSimpleName() + ", check that " + propertyName + " is specified");
            }
            return null;
        }
        if (classes.size() > 1) {
            throw new IllegalArgumentException("More than one implementation of " + expectedType.getSimpleName() + " specified by " + propertyName + ", not sure which one to use!");
        }
        return (Class)classes.iterator().next();
    }
}

