/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import org.jboss.cdi.tck.shrinkwrap.ArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.DummySessionBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;

public class EnterpriseArchiveBuilder
extends ArchiveBuilder<EnterpriseArchiveBuilder, EnterpriseArchive> {
    public static final String DEFAULT_APP_VERSION = "6";
    public static final String DEFAULT_EAR_NAME = "test.ear";
    public static final String DEFAULT_EJB_MODULE_NAME = "test-ejb.jar";
    private boolean hasDefaultWebModule = true;
    private String ejbModuleName = null;

    public EnterpriseArchiveBuilder noDefaultWebModule() {
        this.hasDefaultWebModule = false;
        return this.self();
    }

    public EnterpriseArchiveBuilder withEjbModuleName(String ejbModuleName) {
        this.ejbModuleName = ejbModuleName;
        return this.self();
    }

    @Override
    public EnterpriseArchiveBuilder self() {
        return this;
    }

    @Override
    protected EnterpriseArchive buildInternal() {
        EnterpriseArchive enterpriseArchive = null;
        enterpriseArchive = this.getName() == null ? (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class) : (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)this.getName());
        JavaArchive ejbArchive = null;
        ejbArchive = this.ejbModuleName == null ? (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)DEFAULT_EJB_MODULE_NAME) : (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)this.ejbModuleName);
        ejbArchive.addClass(DummySessionBean.class);
        this.processPackages(ejbArchive);
        this.processClasses(ejbArchive);
        this.processManifestResources((ManifestContainer<?>)ejbArchive);
        this.processResources((ResourceContainer<?>)ejbArchive);
        this.processLibraries((LibraryContainer<?>)enterpriseArchive);
        if (this.beansDescriptor != null) {
            ejbArchive.addAsManifestResource((Asset)new StringAsset(this.beansDescriptor.exportAsString()), this.beansDescriptor.getDescriptorName());
        } else if (this.beansXml != null) {
            ejbArchive.addAsManifestResource(this.beansXml.getSource(), this.beansXml.getTarget());
        } else {
            ejbArchive.addAsManifestResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), "beans.xml");
        }
        if (this.persistenceDescriptor != null) {
            ejbArchive.addAsManifestResource((Asset)new StringAsset(this.persistenceDescriptor.exportAsString()), "persistence.xml");
        }
        enterpriseArchive.addAsModule((Archive)ejbArchive);
        if (this.hasDefaultWebModule) {
            WebArchive webArchive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).setManifest((Asset)new StringAsset(((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).addToClassPath(this.getName() != null ? this.getName() : DEFAULT_EJB_MODULE_NAME)).exportAsString()));
            enterpriseArchive.addAsModule((Archive)webArchive);
        }
        return enterpriseArchive;
    }
}

