/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class RequestContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextAsyncListenerTest.class)).withWebResource("foo.jsp")).withWebResource("bar.jsp")).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="ad"), @SpecAssertion(section="request_context", id="bd")})
    public void testRequestContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page01 = (TextPage)webClient.getPage(this.getPage("complete"));
        Assert.assertTrue((boolean)page01.getContent().contains("onTimeout: null"));
        Assert.assertTrue((boolean)page01.getContent().contains("onError: null"));
        Assert.assertFalse((boolean)page01.getContent().contains("onComplete: null"));
        TextPage page02 = (TextPage)webClient.getPage(this.getPage("complete"));
        Assert.assertNotEquals((Object)this.extractSimpleRequestBeanIdString(page01.getContent()), (Object)this.extractSimpleRequestBeanIdString(page02.getContent()));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="request_context", id="ad")
    public void testRequestContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPage("timeout"));
        Assert.assertFalse((boolean)page.getContent().contains("onTimeout: null"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="request_context", id="ad")
    public void testRequestContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.getPage("error"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="request_context", id="ad")
    public void testRequestContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPage("loop"));
        Assert.assertFalse((boolean)page.getContent().contains("onStartAsync: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    private String getPage(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }

    private String extractSimpleRequestBeanIdString(String content) {
        String[] tokens = content.split(",");
        return tokens[5];
    }
}

