/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.async;

import java.io.IOException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.session.async.SimpleSessionBean;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleAsyncListener
implements AsyncListener {
    public static Long onStartAsync = null;
    public static Long onError = null;
    public static Long onTimeout = null;
    public static Long onComplete = null;
    public static boolean isSessionContextActive = false;
    public static Long simpleSessionBeanId = null;
    private static final SimpleLogger logger = new SimpleLogger(SimpleAsyncListener.class);
    @Inject
    SimpleSessionBean simpleSessionBean;
    @Inject
    BeanManager beanManager;

    public void onComplete(AsyncEvent event) throws IOException {
        logger.log("onComplete", new Object[0]);
        onComplete = System.currentTimeMillis();
        if (onTimeout == null && onError == null) {
            this.checkSessionContextAvailability(event);
            this.writeInfo(event.getAsyncContext().getResponse());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        logger.log("onTimeout", new Object[0]);
        onTimeout = System.currentTimeMillis();
        this.checkSessionContextAvailability(event);
        this.writeInfo(event.getAsyncContext().getResponse());
        event.getAsyncContext().complete();
    }

    public void onError(AsyncEvent event) throws IOException {
        logger.log("onError", new Object[0]);
        onError = System.currentTimeMillis();
        if (this.checkSessionContextAvailability(event)) {
            event.getAsyncContext().complete();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        logger.log("onStartAsync", new Object[0]);
        onStartAsync = System.currentTimeMillis();
        this.checkSessionContextAvailability(event);
    }

    private boolean checkSessionContextAvailability(AsyncEvent event) throws IOException {
        try {
            simpleSessionBeanId = this.simpleSessionBean.getId();
            isSessionContextActive = this.beanManager.getContext(SessionScoped.class).isActive();
        }
        catch (Throwable e) {
            logger.log("Problem while checking request scope: " + e.getMessage(), new Object[0]);
        }
        if (!isSessionContextActive || simpleSessionBeanId == null) {
            ((HttpServletResponse)event.getAsyncContext().getResponse()).setStatus(500);
            return false;
        }
        return true;
    }

    public static void reset() {
        onStartAsync = null;
        onError = null;
        onTimeout = null;
        onComplete = null;
        isSessionContextActive = false;
        simpleSessionBeanId = null;
    }

    private void writeInfo(ServletResponse response) throws IOException {
        response.getWriter().print(SimpleAsyncListener.getInfo());
        response.getWriter().flush();
    }

    public static String getInfo() {
        return String.format("onStartAsync: %s, onError: %s, onTimeout: %s, onComplete: %s, isSessionContextActive: %s, simpleSessionBeanId: %s", onStartAsync, onError, onTimeout, onComplete, isSessionContextActive, simpleSessionBeanId);
    }
}

