/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.implicit;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.implicit.AwardEvent;
import org.jboss.cdi.tck.tests.event.implicit.CourseFullEvent;
import org.jboss.cdi.tck.tests.event.implicit.HonorsLiteral;
import org.jboss.cdi.tck.tests.event.implicit.Registration;
import org.jboss.cdi.tck.tests.event.implicit.Student;
import org.jboss.cdi.tck.tests.event.implicit.StudentDirectory;
import org.jboss.cdi.tck.tests.event.implicit.StudentRegisteredEvent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ImplicitEventTest
extends AbstractTest {
    private static final TypeLiteral<Event<StudentRegisteredEvent>> STUDENT_REGISTERED_EVENT_LITERAL = new TypeLiteral<Event<StudentRegisteredEvent>>(){};
    private static final TypeLiteral<Event<CourseFullEvent>> COURSE_FULL_EVENT_LITERAL = new TypeLiteral<Event<CourseFullEvent>>(){};
    private static final TypeLiteral<Event<AwardEvent>> AWARD_EVENT_LITERAL = new TypeLiteral<Event<AwardEvent>>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ImplicitEventTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtin_event", id="a")
    public void testImplicitEventExistsForEachEventType() {
        assert (this.getBeans(STUDENT_REGISTERED_EVENT_LITERAL, new Annotation[0]).size() == 1);
        assert (this.getBeans(COURSE_FULL_EVENT_LITERAL, new Annotation[0]).size() == 1);
        assert (this.getBeans(AWARD_EVENT_LITERAL, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertion(section="builtin_event", id="b")
    public void testImplicitEventHasAllExplicitBindingTypes() {
        assert (this.getBeans(AWARD_EVENT_LITERAL, new Annotation[]{AnyLiteral.INSTANCE, new HonorsLiteral()}).size() == 1);
    }

    @SpecAssertion(section="event_types_and_qualifier_types", id="i")
    public void testImplicitEventHasAnyBinding() {
        assert (this.getUniqueBean(STUDENT_REGISTERED_EVENT_LITERAL, new Annotation[0]).getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (this.getUniqueBean(COURSE_FULL_EVENT_LITERAL, new Annotation[0]).getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (this.getUniqueBean(AWARD_EVENT_LITERAL, new Annotation[0]).getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (this.getUniqueBean(AWARD_EVENT_LITERAL, new Annotation[]{new HonorsLiteral()}).getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (this.getUniqueBean(AWARD_EVENT_LITERAL, new Annotation[]{AnyLiteral.INSTANCE, new HonorsLiteral()}) == this.getUniqueBean(AWARD_EVENT_LITERAL, new Annotation[]{new HonorsLiteral()}));
    }

    @Test
    @SpecAssertion(section="builtin_event", id="d")
    public void testImplicitEventHasDependentScope() {
        assert (this.getUniqueBean(STUDENT_REGISTERED_EVENT_LITERAL, new Annotation[0]).getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="builtin_event", id="e")
    public void testImplicitEventHasNoName() {
        assert (this.getUniqueBean(STUDENT_REGISTERED_EVENT_LITERAL, new Annotation[0]).getName() == null);
    }

    @Test
    @SpecAssertion(section="builtin_event", id="f")
    public void testImplicitEventHasImplementation() {
        StudentDirectory directory = this.getInstanceByType(StudentDirectory.class, new Annotation[0]);
        directory.reset();
        Registration registration = this.getInstanceByType(Registration.class, new Annotation[0]);
        assert (registration.getInjectedCourseFullEvent() != null);
        assert (registration.getInjectedStudentRegisteredEvent() != null);
        Event<StudentRegisteredEvent> event = registration.getInjectedStudentRegisteredEvent();
        Student student = new Student("Dan");
        event.fire((Object)new StudentRegisteredEvent(student));
        assert (directory.getStudents().size() == 1);
        assert (directory.getStudents().contains(student));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtin_event", id="g"), @SpecAssertion(section="passivation_capable_dependency", id="eb")})
    public void testImplicitEventIsPassivationCapable() throws IOException, ClassNotFoundException {
        StudentDirectory directory = this.getInstanceByType(StudentDirectory.class, new Annotation[0]);
        directory.reset();
        Registration registration = this.getInstanceByType(Registration.class, new Annotation[0]);
        Event<StudentRegisteredEvent> event = registration.getInjectedStudentRegisteredEvent();
        assert (Serializable.class.isAssignableFrom(event.getClass()));
        byte[] serializedEvent = this.passivate(event);
        Event eventCopy = (Event)this.activate(serializedEvent);
        Student student = new Student("Dan");
        eventCopy.fire((Object)new StudentRegisteredEvent(student));
        assert (directory.getStudents().size() == 1);
        assert (directory.getStudents().contains(student));
    }
}

