/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.el;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.el.Counter;
import org.jboss.cdi.tck.tests.lookup.el.Salmon;
import org.jboss.cdi.tck.tests.lookup.el.Tuna;
import org.jboss.cdi.tck.tests.lookup.el.TunaFarm;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ResolutionByNameTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolutionByNameTest.class)).build();
    }

    @Test
    @SpecAssertion(section="dependent_scope_el", id="a")
    public void testQualifiedNameLookup() {
        assert (((Boolean)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{(game.value == 'foo' and game.value == 'foo') ? game.value == 'foo' : false}", Boolean.class)).booleanValue());
        assert (this.getInstanceByType(Counter.class, new Annotation[0]).getCount() == 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="contextual_instance", id="a"), @SpecAssertion(section="contextual_instance", id="b")})
    public void testContextCreatesNewInstanceForInjection() {
        Context requestContext = this.getCurrentManager().getContext(RequestScoped.class);
        Bean<Tuna> tunaBean = this.getBeans(Tuna.class, new Annotation[0]).iterator().next();
        assert (requestContext.get(tunaBean) == null);
        TunaFarm tunaFarm = (TunaFarm)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{tunaFarm}", TunaFarm.class);
        assert (tunaFarm.tuna != null);
        long timestamp = tunaFarm.tuna.getTimestamp();
        Tuna tuna = (Tuna)requestContext.get(tunaBean);
        assert (tuna != null);
        assert (timestamp == tuna.getTimestamp());
    }

    @Test
    @SpecAssertion(section="el", id="c")
    public void testUnresolvedNameReturnsNull() {
        assert (this.getCurrentManager().getELResolver().getValue(this.getCurrentConfiguration().getEl().createELContext(this.getCurrentManager()), null, (Object)"nonExistingTuna") == null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="el", id="d"), @SpecAssertion(section="names", id="a")})
    public void testELResolverReturnsContextualInstance() {
        Salmon salmon = this.getInstanceByType(Salmon.class, new Annotation[0]);
        salmon.setAge(3);
        assert ((Integer)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{salmon.age}", Integer.class) == 3);
    }
}

