/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextAsyncListenerTest.class)).withWebResource("foo.jsp")).withWebResource("bar.jsp")).build();
    }

    @Test
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPage("complete"));
        Assert.assertTrue((boolean)page.getContent().contains("onTimeout: null"));
        Assert.assertTrue((boolean)page.getContent().contains("onError: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    @Test
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPage("timeout"));
        Assert.assertFalse((boolean)page.getContent().contains("onTimeout: null"));
    }

    @Test
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.getPage("error"));
    }

    @Test
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPage("loop"));
        Assert.assertFalse((boolean)page.getContent().contains("onStartAsync: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    private String getPage(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }
}

