/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.discovery.enterprise;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Beans11DescriptorImpl;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Alpha;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Bravo;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Charlie;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Delta;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Echo;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Ping;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.VerifyingExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseBeanDiscoveryTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static EnterpriseArchive createTestArchive() {
        JavaArchive alpha = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Alpha.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ALL).exportAsString()), "beans.xml");
        JavaArchive bravo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Bravo.class)).addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        JavaArchive charlie = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Charlie.class)).addAsManifestResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), "beans.xml");
        JavaArchive delta = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Delta.class);
        JavaArchive echo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Echo.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ANNOTATED).exportAsString()), "beans.xml");
        JavaArchive foxtrot = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Foxtrot.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.NONE).exportAsString()), "beans.xml");
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(EnterpriseBeanDiscoveryTest.class)).withClasses(VerifyingExtension.class)).withExtension(VerifyingExtension.class)).withLibrary(Ping.class)).withLibraries(alpha, bravo, charlie, delta, echo, foxtrot)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ba"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testExplicitBeanArchiveModeAll(Alpha alpha) {
        this.assertDiscoveredAndAvailable(alpha, Alpha.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bb"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testExplicitBeanArchiveEmptyDescriptor(Bravo bravo) {
        this.assertDiscoveredAndAvailable(bravo, Bravo.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="tc"), @SpecAssertion(section="bean_discovery", id="ta")})
    public void testExplicitBeanArchiveLegacyDescriptor(Charlie charlie) {
        this.assertDiscoveredAndAvailable(charlie, Charlie.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testImplicitBeanArchiveNoDescriptor(Delta delta) {
        this.assertDiscoveredAndAvailable(delta, Delta.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testImplicitBeanArchiveModeAnnotated(Echo echo) {
        this.assertDiscoveredAndAvailable(echo, Echo.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="cb"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testImplicitBeanArchiveModeNone(Foxtrot foxtrot) {
        this.assertDiscoveredAndAvailable(foxtrot, Foxtrot.class);
    }

    private <T extends Ping> void assertDiscoveredAndAvailable(T reference, Class<T> clazz) {
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(clazz));
        Assert.assertNotNull(reference);
        reference.pong();
        this.getUniqueBean(clazz, new Annotation[0]);
    }
}

