/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.alternative.metadata;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Bread;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Cheap;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.CheapLiteral;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Expensive;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.ExpensiveLiteral;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Grocery;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.GroceryInterceptor;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.GroceryWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Milk;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Sausage;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Shop;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.TropicalFruit;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Yogurt;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AlternativeMetadataTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeMetadataTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{GroceryInterceptor.class.getName()}).up())).withExtension(ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="ha")
    public void testGetBaseTypeUsedToDetermineTypeOfInjectionPoint() {
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfFruitFieldUsed());
        Assert.assertEquals((Object)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getFruit().getMetadata().getType(), TropicalFruit.class);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="hb")
    public void testGetBaseTypeUsedToDetermineTypeOfInitializerInjectionPoint() {
        Assert.assertEquals((Object)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getInitializerFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfInitializerTropicalFruitParameterUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="ka")
    public void testGetTypeClosureUsed() {
        Assert.assertTrue((boolean)GroceryWrapper.isGetTypeClosureUsed());
        Assert.assertEquals((int)this.getBeans(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).iterator().next().getTypes().size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Shop.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="l")
    public void testGetAnnotationUsedForGettingScopeInformation() {
        Assert.assertEquals((Object)this.getBeans(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).iterator().next().getScope(), RequestScoped.class);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="m")
    public void testGetAnnotationUsedForGettingQualifierInformation() {
        Assert.assertEquals((int)this.getBeans(Grocery.class, new CheapLiteral()).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Grocery.class, new ExpensiveLiteral()).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="n")
    public void testGetAnnotationUsedForGettingStereotypeInformation() {
        Assert.assertNotNull((Object)this.getInstanceByName("grocery"));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="p")
    public void testGetAnnotationUsedForGettingInterceptorInformation() {
        Grocery grocery = this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE});
        Assert.assertEquals((String)grocery.foo(), (String)"foo");
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="r")
    public void testPreviouslyNonInjectAnnotatedConstructorIsUsed() {
        Assert.assertTrue((boolean)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).isConstructorWithParameterUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="t")
    public void testPreviouslyNonInjectAnnotatedFieldIsInjected() {
        Assert.assertTrue((boolean)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).isVegetablesInjected());
    }

    @SpecAssertion(section="alternative_metadata_sources", id="u")
    public void testExtraQualifierIsAppliedToInjectedField() {
        Assert.assertNotNull((Object)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getFruit());
        Set qualifiers = this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getFruit().getMetadata().getQualifiers();
        Assert.assertEquals((int)qualifiers.size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="v")
    public void testProducesCreatesProducerField() {
        Assert.assertEquals((int)this.getBeans(Bread.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)1);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="w")
    public void testInjectCreatesInitializerMethod() {
        Assert.assertTrue((boolean)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).isWaterInjected());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="x")
    public void testQualifierAddedToInitializerParameter() {
        Set qualifiers = this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getInitializerFruit().getMetadata().getQualifiers();
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="y")
    public void testProducesCreatesProducerMethod() {
        Assert.assertEquals((int)this.getBeans(Milk.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)1);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="z")
    public void testQualifierIsAppliedToProducerMethod() {
        Assert.assertEquals((int)this.getBeans(Yogurt.class, new ExpensiveLiteral()).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Yogurt.class, new CheapLiteral()).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="aa")
    public void testQualifierIsAppliedToProducerMethodParameter() {
        Set qualifiers = this.getInstanceByType(Yogurt.class, new Annotation[]{AnyLiteral.INSTANCE}).getFruit().getMetadata().getQualifiers();
        Assert.assertEquals((int)qualifiers.size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="ae"), @SpecAssertion(section="alternative_metadata_sources", id="ag")})
    public void testObserverMethod() {
        this.getCurrentManager().fireEvent((Object)new Milk(true), new Annotation[0]);
        Milk event = this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getObserverEvent();
        TropicalFruit parameter = this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).getObserverParameter();
        Assert.assertNotNull((Object)event);
        Assert.assertNotNull((Object)parameter);
        Assert.assertEquals((int)parameter.getMetadata().getQualifiers().size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)parameter.getMetadata().getQualifiers(), Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="af")
    public void testExtraQualifierAppliedToObservesMethodParameter() {
        this.getCurrentManager().fireEvent((Object)new Bread(true), new Annotation[0]);
        Assert.assertFalse((boolean)this.getInstanceByType(Grocery.class, new Annotation[]{AnyLiteral.INSTANCE}).isObserver2Used());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="h")
    public void testContainerUsesOperationsOfAnnotatedNotReflectionApi() {
        Assert.assertEquals((int)this.getBeans(Sausage.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Sausage.class, new Annotation[]{new AnnotationLiteral<Expensive>(){}}).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(Sausage.class, new Annotation[]{new AnnotationLiteral<Cheap>(){}}).isEmpty());
    }
}

