/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.annotated;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.annotated.AbstractC;
import org.jboss.cdi.tck.tests.extensions.annotated.ClassD;
import org.jboss.cdi.tck.tests.extensions.annotated.Dog;
import org.jboss.cdi.tck.tests.extensions.annotated.InterfaceA;
import org.jboss.cdi.tck.tests.extensions.annotated.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.annotated.TestAnnotatedType;
import org.jboss.cdi.tck.tests.extensions.annotated.Type;
import org.jboss.cdi.tck.tests.extensions.annotated.VetoedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ProcessAnnotatedTypeTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProcessAnnotatedTypeTest.class)).withExtension(ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pat", id="aa"), @SpecAssertion(section="pat", id="ab"), @SpecAssertion(section="bean_discovery", id="ba"), @SpecAssertion(section="pat", id="j")})
    public void testProcessAnnotatedTypeEventsSent() {
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.getAnnotatedclasses().contains(AbstractC.class));
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.getAnnotatedclasses().contains(ClassD.class));
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.getAnnotatedclasses().contains(Dog.class));
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.getAnnotatedclasses().contains(InterfaceA.class));
    }

    @Test
    @SpecAssertion(section="pat", id="ac")
    public void testProcessAnnotatedTypeFiredForEnum() {
        Assert.assertTrue((boolean)ProcessAnnotatedTypeObserver.getAnnotatedclasses().contains(Type.class));
    }

    @Test
    @SpecAssertion(section="pat", id="ba")
    public void testGetAnnotatedType() {
        AnnotatedType<Dog> annotatedType = ProcessAnnotatedTypeObserver.getDogAnnotatedType();
        Assert.assertEquals((Object)annotatedType.getBaseType(), Dog.class);
        Set annotatedMethods = annotatedType.getMethods();
        Assert.assertEquals((int)annotatedMethods.size(), (int)3);
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            HashSet<String> validMethodNames = new HashSet<String>(Arrays.asList("bite", "live", "drinkMilk"));
            if (validMethodNames.contains(annotatedMethod.getJavaMember().getName())) continue;
            Assert.fail((String)("Invalid method name found" + annotatedMethod.getJavaMember().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pat", id="bb"), @SpecAssertion(section="pat", id="ca")})
    public void testSetAnnotatedType() {
        Assert.assertTrue((boolean)TestAnnotatedType.isGetConstructorsUsed());
        Assert.assertTrue((boolean)TestAnnotatedType.isGetFieldsUsed());
        Assert.assertTrue((boolean)TestAnnotatedType.isGetMethodsUsed());
    }

    @Test
    @SpecAssertion(section="pat", id="bc")
    public void testVeto() {
        Assert.assertTrue((boolean)this.getCurrentManager().getBeans(VetoedBean.class, new Annotation[0]).isEmpty());
    }
}

