/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged;

import javax.enterprise.inject.spi.Unmanaged;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Builder;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Hammer;
import org.jboss.cdi.tck.tests.extensions.beanManager.unmanaged.Nail;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class UnmanagedInstanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(UnmanagedInstanceTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_unmanaged_instance", id="a")})
    public void testObtainUnmanagedInstance() {
        Builder.reset();
        Nail.reset();
        Hammer.reset();
        Unmanaged unmanagedBuilder = new Unmanaged(Builder.class);
        Unmanaged.UnmanagedInstance unmanagedBuilderInstance = unmanagedBuilder.newInstance();
        Builder builder = (Builder)unmanagedBuilderInstance.produce().inject().postConstruct().get();
        builder.build();
        Assert.assertTrue((boolean)Builder.postConstructCalled);
        Assert.assertTrue((boolean)Nail.postConstructCalled);
        Assert.assertTrue((boolean)Hammer.postConstructCalled);
        unmanagedBuilderInstance.preDestroy().dispose();
        Assert.assertTrue((boolean)Builder.preDestroyCalled);
        Assert.assertTrue((boolean)Nail.preDestroyCalled);
        Assert.assertFalse((boolean)Hammer.preDestroyCalled);
    }
}

