/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.atd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Boss;

public class AfterTypeDiscoveryObserver
implements Extension {
    private List<Class<?>> interceptors = null;
    private List<Class<?>> alternatives = null;
    private List<Class<?>> decorators = null;
    private boolean bossObserved = false;

    public void observeAfterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        this.interceptors = Collections.unmodifiableList(new ArrayList(event.getInterceptors()));
        this.alternatives = Collections.unmodifiableList(new ArrayList(event.getAlternatives()));
        this.decorators = Collections.unmodifiableList(new ArrayList(event.getDecorators()));
        event.addAnnotatedType(beanManager.createAnnotatedType(Boss.class), AfterTypeDiscoveryObserver.class.getName());
        event.getInterceptors().remove(0);
        Collections.reverse(event.getDecorators());
        event.getAlternatives().clear();
    }

    public void observeBossAnnotatedType(@Observes ProcessAnnotatedType<Boss> event) {
        this.bossObserved = true;
    }

    public List<Class<?>> getInterceptors() {
        return this.interceptors;
    }

    public List<Class<?>> getAlternatives() {
        return this.alternatives;
    }

    public List<Class<?>> getDecorators() {
        return this.decorators;
    }

    public boolean isBossObserved() {
        return this.bossObserved;
    }
}

