/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Apple;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.AppleTree;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Chicken;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Egg;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class DisposerMethodInheritanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DisposerMethodInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="db"), @SpecAssertion(section="member_level_inheritance", id="dh")})
    public void testManagedBeanDisposerMethodNotInherited() {
        Bean<Apple> bean = this.getUniqueBean(Apple.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Apple apple = (Apple)bean.create(ctx);
        Assert.assertEquals(apple.getTree().getClass(), AppleTree.class);
        bean.destroy((Object)apple, ctx);
        Assert.assertEquals((int)Apple.disposedBy.size(), (int)1);
        Assert.assertEquals(Apple.disposedBy.get(0), AppleTree.class);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="de"), @SpecAssertion(section="member_level_inheritance", id="dk")})
    public void testSessionBeanDisposerMethodNotInherited() {
        Bean<Egg> bean = this.getUniqueBean(Egg.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Egg egg = (Egg)bean.create(ctx);
        Assert.assertEquals(egg.getChicken().getClass(), Chicken.class);
        bean.destroy((Object)egg, ctx);
        Assert.assertEquals((int)Egg.disposedBy.size(), (int)1);
        Assert.assertEquals(Egg.disposedBy.get(0), Chicken.class);
    }
}

