/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.method.definition;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.literals.NamedLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Acorn;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Animal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Apple;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.AppleTree;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BeanWithStaticProducerMethod;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Bite;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Cherry;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DaddyLongLegs;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Deadliest;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlyAnimal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlySpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Egg;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.FunnelWeaver;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Pollen;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.WolfSpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Yummy;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ProducerMethodDefinitionTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private static final Annotation DEADLIEST_LITERAL = new AnnotationLiteral<Deadliest>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="b"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="a")})
    public void testStaticMethod() throws Exception {
        assert (this.getBeans(String.class, TAME_LITERAL).size() == 1);
        assert (this.getInstanceByType(String.class, TAME_LITERAL).equals(BeanWithStaticProducerMethod.getString()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="aa")})
    public void testProducerOnNonBean() throws Exception {
        assert (this.getBeans(Cherry.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method", id="b")})
    public void testStaticDisposerMethod() throws Exception {
        assert (this.getBeans(String.class, TAME_LITERAL).size() == 1);
        String aString = this.getInstanceByType(String.class, TAME_LITERAL);
        Bean<String> stringBean = this.getBeans(String.class, TAME_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(stringBean);
        stringBean.destroy((Object)aString, creationalContext);
        assert (BeanWithStaticProducerMethod.stringDestroyed);
    }

    @Test
    @SpecAssertion(section="producer_method", id="ga")
    public void testParameterizedReturnType() throws Exception {
        assert (this.getBeans(new TypeLiteral<FunnelWeaver<Spider>>(){}, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method", id="c"), @SpecAssertion(section="declaring_producer_method", id="a"), @SpecAssertion(section="builtin_qualifiers", id="a0"), @SpecAssertion(section="builtin_qualifiers", id="aa")})
    public void testDefaultBindingType() throws Exception {
        assert (this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().size() == 2);
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains((Object)new DefaultLiteral()));
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains(AnyLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_types", id="c"), @SpecAssertion(section="bean_types", id="l")})
    public void testApiTypeForClassReturn() throws Exception {
        assert (this.getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        assert (tarantula.getTypes().size() == 6);
        assert (tarantula.getTypes().contains(Tarantula.class));
        assert (tarantula.getTypes().contains(DeadlySpider.class));
        assert (tarantula.getTypes().contains(Spider.class));
        assert (tarantula.getTypes().contains(Animal.class));
        assert (tarantula.getTypes().contains(DeadlyAnimal.class));
        assert (tarantula.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_method_types", id="a")
    public void testApiTypeForInterfaceReturn() throws Exception {
        assert (this.getBeans(Bite.class, new Annotation[0]).size() == 1);
        Bean<Bite> animal = this.getBeans(Bite.class, new Annotation[0]).iterator().next();
        assert (animal.getTypes().size() == 2);
        assert (animal.getTypes().contains(Bite.class));
        assert (animal.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_method_types", id="ba")
    public void testApiTypeForPrimitiveReturn() throws Exception {
        assert (this.getBeans(Integer.class, new Annotation[0]).size() == 1);
        Bean<Integer> integer = this.getBeans(Integer.class, new Annotation[0]).iterator().next();
        assert (integer.getTypes().size() == 2);
        assert (integer.getTypes().contains(Integer.TYPE));
        assert (integer.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_types", id="bb"), @SpecAssertion(section="legal_bean_types", id="i")})
    public void testApiTypeForArrayTypeReturn() throws Exception {
        assert (this.getBeans(Spider[].class, new Annotation[0]).size() == 1);
        Bean<Spider[]> spiders = this.getBeans(Spider[].class, new Annotation[0]).iterator().next();
        assert (spiders.getTypes().size() == 2);
        assert (spiders.getTypes().contains(Spider[].class));
        assert (spiders.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="be"), @SpecAssertion(section="producer_method", id="k"), @SpecAssertion(section="declaring_bean_qualifiers", id="b")})
    public void testBindingType() throws Exception {
        assert (this.getBeans(Tarantula.class, TAME_LITERAL).size() == 1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, TAME_LITERAL).iterator().next();
        assert (tarantula.getQualifiers().size() == 2);
        assert (tarantula.getQualifiers().contains(TAME_LITERAL));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="ba"), @SpecAssertion(section="producer_method", id="k")})
    public void testScopeType() throws Exception {
        assert (this.getBeans(DaddyLongLegs.class, TAME_LITERAL).size() == 1);
        Bean<DaddyLongLegs> daddyLongLegs = this.getBeans(DaddyLongLegs.class, TAME_LITERAL).iterator().next();
        assert (daddyLongLegs.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="bb"), @SpecAssertion(section="declaring_bean_name", id="b")})
    public void testNamedMethod() throws Exception {
        assert (this.getBeans(BlackWidow.class, TAME_LITERAL).size() == 1);
        Bean<BlackWidow> blackWidowSpider = this.getBeans(BlackWidow.class, TAME_LITERAL).iterator().next();
        assert (blackWidowSpider.getName().equals("blackWidow"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_method", id="bb"), @SpecAssertion(section="default_name", id="b"), @SpecAssertion(section="default_name", id="fb"), @SpecAssertion(section="declaring_bean_name", id="d")})
    public void testDefaultNamedMethod() throws Exception {
        String name = "produceDaddyLongLegs";
        Bean<DaddyLongLegs> daddyLongLegs = this.getUniqueBean(DaddyLongLegs.class, TAME_LITERAL);
        Assert.assertEquals((String)daddyLongLegs.getName(), (String)name);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)daddyLongLegs.getQualifiers(), new Annotation[]{AnyLiteral.INSTANCE, TAME_LITERAL, new NamedLiteral(name)}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="b"), @SpecAssertion(section="declaring_producer_method", id="ba"), @SpecAssertion(section="default_scope", id="c"), @SpecAssertion(section="declaring_producer_method", id="bd")})
    public void testStereotypeSpecifiesScope() throws Exception {
        assert (this.getBeans(WolfSpider.class, TAME_LITERAL).size() == 1);
        Bean<WolfSpider> wolfSpider = this.getBeans(WolfSpider.class, TAME_LITERAL).iterator().next();
        assert (wolfSpider.getScope().equals(RequestScoped.class));
    }

    @Test(expectedExceptions={UnsatisfiedResolutionException.class})
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="da"), @SpecAssertion(section="specialization", id="cb")})
    public void testNonStaticProducerMethodNotInheritedBySpecializingSubclass() {
        assert (this.getBeans(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size() == 0);
        this.getInstanceByType(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="da"), @SpecAssertion(section="member_level_inheritance", id="dg")})
    public void testNonStaticProducerMethodNotInherited() {
        assert (this.getBeans(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size() == 1);
        assert (this.getInstanceByType(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).getTree().getClass().equals(AppleTree.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="method_constructor_parameter_qualifiers", id="a"), @SpecAssertion(section="declaring_producer_method", id="i"), @SpecAssertion(section="declaring_producer_method", id="h"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="e")})
    public void testBindingTypesAppliedToProducerMethodParameters() {
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantula);
        Tarantula instance = (Tarantula)tarantula.create(creationalContext);
        assert (instance.getDeathsCaused() == 1);
    }

    @Test
    @SpecAssertion(section="producer_method", id="e")
    public void testDependentProducerReturnsNullValue() {
        assert (this.getInstanceByType(Acorn.class, new Annotation[0]) == null);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="producer_method", id="f")
    public void testNonDependentProducerReturnsNullValue() {
        this.getInstanceByType(Pollen.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).ping();
        Assert.fail((String)"IllegalProductException not thrown");
    }

    @Test
    @SpecAssertion(section="producer_method", id="iaa")
    public void testTypeVariableReturnType() {
        assert (this.getBeans(new TypeLiteral<List<Spider>>(){}, new Annotation[0]).size() == 1);
    }
}

