/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class InjectionIntoNonContextualComponentTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionIntoNonContextualComponentTest.class)).withWebXml("web2.xml")).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="ef"), @SpecAssertion(section="fields_initializer_methods", id="ae"), @SpecAssertion(section="fields_initializer_methods", id="bn"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoServlet() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods", id="af"), @SpecAssertion(section="fields_initializer_methods", id="bm"), @SpecAssertion(section="initializer_methods", id="b")})
    public void testServletInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/Servlet?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="eg"), @SpecAssertion(section="fields_initializer_methods", id="ag"), @SpecAssertion(section="fields_initializer_methods", id="bq"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods", id="ah"), @SpecAssertion(section="fields_initializer_methods", id="bp"), @SpecAssertion(section="initializer_methods", id="b")})
    public void testFilterInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestFilter?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="ea"), @SpecAssertion(section="fields_initializer_methods", id="ai"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoServletListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods", id="aj"), @SpecAssertion(section="initializer_methods", id="b")})
    public void testServletListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/ServletListener?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="eb"), @SpecAssertion(section="fields_initializer_methods", id="am"), @SpecAssertion(section="fields_initializer_methods", id="an"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoTagHandler() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        WebResponse response = webClient.getPage(this.contextPath + "TagPage.jsp").getWebResponse();
        assert (response.getStatusCode() == 200);
        assert (response.getContentAsString().contains("Injection works."));
        assert (response.getContentAsString().contains("Initializer works."));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="ec"), @SpecAssertion(section="fields_initializer_methods", id="as"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoTagLibraryListener() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=injection");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="fields_initializer_methods", id="at"), @SpecAssertion(section="initializer_methods", id="b")})
    public void testTagLibraryListenerInitializerMethodCalled() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "Test/TagLibraryListener?test=initializer");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="injection", id="d"), @SpecAssertion(section="fields_initializer_methods", id="au"), @SpecAssertion(section="fields_initializer_methods", id="av"), @SpecAssertion(section="injected_fields", id="b")})
    public void testInjectionIntoJSFManagedBean() throws Exception {
        WebClient webclient = new WebClient();
        webclient.setThrowExceptionOnFailingStatusCode(true);
        String content = webclient.getPage(this.contextPath + "ManagedBeanTestPage.jsf").getWebResponse().getContentAsString();
        assert (content.contains("Injection works"));
        assert (content.contains("Initializer works"));
    }
}

