/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.typesafe.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.African;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Animal;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Australian;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Bird;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Canary;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Cat;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ChunkyLiteral;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Cod;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.DomesticCat;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Dove;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Emu;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.European;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ExpensiveLiteral;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Farmer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.FlightlessBird;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Halibut;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Lion;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Max;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Min;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.NumberProducer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Parrot;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.RoundWhitefish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ScottishFish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ScottishFishFarmer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Sole;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Spider;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Tame;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Tuna;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Whitefish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ResolutionByTypeTest
extends AbstractTest {
    private static final TypeLiteral<FlightlessBird<Australian>> AUSTRALIAN_FLIGHTLESS_BIRD = new TypeLiteral<FlightlessBird<Australian>>(){};
    private static final TypeLiteral<FlightlessBird<European>> EUROPEAN_FLIGHTLESS_BIRD = new TypeLiteral<FlightlessBird<European>>(){};
    private static final TypeLiteral<Cat<European>> EUROPEAN_CAT = new TypeLiteral<Cat<European>>(){};
    private static final TypeLiteral<Cat<African>> AFRICAN_CAT = new TypeLiteral<Cat<African>>(){};
    private static final Annotation TAME = new AnnotationLiteral<Tame>(){};
    private static final Annotation WILD = new AnnotationLiteral<Wild>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolutionByTypeTest.class)).build();
    }

    @Test
    @SpecAssertion(section="performing_typesafe_resolution", id="lb")
    public void testDefaultBindingTypeAssumed() throws Exception {
        Set<Bean<Tuna>> possibleTargets = this.getBeans(Tuna.class, new Annotation[0]);
        Assert.assertEquals((int)possibleTargets.size(), (int)1);
        Assert.assertTrue((boolean)possibleTargets.iterator().next().getTypes().contains(Tuna.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injected_field_qualifiers", id="b"), @SpecAssertion(section="performing_typesafe_resolution", id="lc"), @SpecAssertion(section="declaring_bean_qualifiers", id="d"), @SpecAssertion(section="performing_typesafe_resolution", id="la"), @SpecAssertion(section="multiple_qualifiers", id="a"), @SpecAssertion(section="multiple_qualifiers", id="d")})
    public void testAllQualifiersSpecifiedForResolutionMustAppearOnBean() {
        Set<Bean<Animal>> animalBeans = this.getBeans(Animal.class, new Annotation[]{new ChunkyLiteral(), new AnnotationLiteral<Whitefish>(){}});
        Assert.assertEquals((int)animalBeans.size(), (int)1);
        Assert.assertTrue((boolean)animalBeans.iterator().next().getTypes().contains(Cod.class));
        Set<Bean<ScottishFish>> scottishFishBeans = this.getBeans(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}});
        Assert.assertEquals((int)scottishFishBeans.size(), (int)2);
        for (Bean<ScottishFish> bean : scottishFishBeans) {
            if (bean.getTypes().contains(Cod.class) || bean.getTypes().contains(Sole.class)) continue;
            Assert.fail();
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="ka")})
    public void testResolveByTypeWithTypeParameter() throws Exception {
        Set<Bean<Farmer<ScottishFish>>> beans = this.getBeans(new TypeLiteral<Farmer<ScottishFish>>(){}, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertTrue((boolean)beans.iterator().next().getTypes().contains(ScottishFishFarmer.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="j"), @SpecAssertion(section="legal_bean_types", id="i")})
    public void testResolveByTypeWithArray() throws Exception {
        Assert.assertEquals((int)this.getBeans(Spider[].class, new Annotation[0]).size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="i"), @SpecAssertion(section="null", id="aa"), @SpecAssertion(section="null", id="ab"), @SpecAssertion(section="multiple_qualifiers", id="b"), @SpecAssertion(section="multiple_qualifiers", id="c"), @SpecAssertion(section="legal_bean_types", id="j")})
    public void testResolveByTypeWithPrimitives() {
        Assert.assertEquals((int)this.getBeans(Double.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Double.TYPE, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)2);
        Double min = this.getInstanceByType(Double.class, new Annotation[]{new AnnotationLiteral<Min>(){}});
        double max = this.getInstanceByType(Double.TYPE, new Annotation[]{new AnnotationLiteral<Max>(){}});
        Assert.assertEquals((Object)min, (Object)0.0);
        Assert.assertEquals((Object)max, (Object)NumberProducer.max);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="ld"), @SpecAssertion(section="qualifier_annotation_members", id="b")})
    public void testResolveByTypeWithNonBindingMembers() throws Exception {
        Set<Bean<Animal>> beans = this.getBeans(Animal.class, new Annotation[]{new ExpensiveLiteral(){

            @Override
            public int cost() {
                return 60;
            }

            @Override
            public boolean veryExpensive() {
                return true;
            }
        }, new AnnotationLiteral<Whitefish>(){}});
        Assert.assertEquals((int)beans.size(), (int)2);
        HashSet classes = new HashSet();
        for (Bean<Animal> bean : beans) {
            classes.addAll(bean.getTypes());
        }
        Assert.assertTrue((boolean)classes.contains(Halibut.class));
        Assert.assertTrue((boolean)classes.contains(RoundWhitefish.class));
        Assert.assertFalse((boolean)classes.contains(Sole.class));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="a")
    public void testBeanTypesOnManagedBean() {
        Assert.assertEquals((int)this.getBeans(Canary.class, new Annotation[0]).size(), (int)1);
        Bean<Canary> bean = this.getUniqueBean(Canary.class, new Annotation[0]);
        Assert.assertTrue((boolean)this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Canary.class, Object.class}));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="e")
    public void testGenericBeanTypesOnManagedBean() {
        Assert.assertEquals((int)this.getBeans(AUSTRALIAN_FLIGHTLESS_BIRD, new Annotation[0]).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Emu.class, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(EUROPEAN_FLIGHTLESS_BIRD, new Annotation[0]).isEmpty());
        Bean<FlightlessBird<Australian>> bean = this.getUniqueBean(AUSTRALIAN_FLIGHTLESS_BIRD, new Annotation[0]);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{AUSTRALIAN_FLIGHTLESS_BIRD.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="c")
    public void testBeanTypesOnProducerMethod() {
        Assert.assertEquals((int)this.getBeans(Parrot.class, new Annotation[0]).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        Bean<Parrot> bean = this.getUniqueBean(Parrot.class, new Annotation[0]);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Parrot.class, Object.class}));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="h")
    public void testGenericBeanTypesOnProducerField() {
        Assert.assertEquals((int)this.getBeans(EUROPEAN_CAT, TAME).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(DomesticCat.class, TAME).isEmpty());
        Bean<Cat<European>> bean = this.getUniqueBean(EUROPEAN_CAT, TAME);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{EUROPEAN_CAT.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="g")
    public void testGenericBeanTypesOnProducerMethod() {
        Assert.assertEquals((int)this.getBeans(AFRICAN_CAT, WILD).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Lion.class, WILD).isEmpty());
        Bean<Cat<African>> bean = this.getUniqueBean(AFRICAN_CAT, WILD);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{AFRICAN_CAT.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="restricting_bean_types", id="d")
    public void testBeanTypesOnProducerField() {
        Assert.assertEquals((int)this.getBeans(Dove.class, new Annotation[0]).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        Bean<Dove> bean = this.getUniqueBean(Dove.class, new Annotation[0]);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Dove.class, Object.class}));
    }
}

