/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Dao;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.InjectedBean;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.IntegerHashMap;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Result;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AssignabilityOfRawAndParameterizedTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AssignabilityOfRawAndParameterizedTypesTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="performing_typesafe_resolution", id="kb"), @SpecAssertion(section="legal_bean_types", id="f"), @SpecAssertion(section="legal_bean_types", id="g"), @SpecAssertion(section="assignable_parameters", id="a")})
    public void testAssignabilityToRawType() {
        Assert.assertEquals((int)this.getBeans(Dao.class, new Annotation[0]).size(), (int)4);
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="ba")
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithActualTypes() {
        assert (this.getBeans(new TypeLiteral<Map<Integer, Integer>>(){}, new Annotation[0]).size() == 2);
        assert (this.getBeans(new TypeLiteral<HashMap<Integer, Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="assignable_parameters", id="c")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcards() {
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).size() == 1);
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="legal_injection_point_types", id="b")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcardsAtInjectionPoint() {
        assert (this.getInstanceByType(InjectedBean.class, new Annotation[0]).getMap() instanceof IntegerHashMap);
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="da")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards() {
        Set<Bean<Result<? extends Throwable, ? super Exception>>> beans = this.getBeans(new TypeLiteral<Result<? extends Throwable, ? super Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="db")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards2() {
        Set<Bean<Result<? extends Exception, ? super Exception>>> beans = this.getBeans(new TypeLiteral<Result<? extends Exception, ? super Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="e")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithActualTypes() {
        Set<Bean<Result<Exception, Exception>>> beans = this.getBeans(new TypeLiteral<Result<Exception, Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test
    @SpecAssertion(section="assignable_parameters", id="f")
    public <T1 extends Exception, T2 extends Exception, T3> void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeTypeVariable() {
        Set beans = this.getBeans(new TypeLiteral<Result<T1, T2>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
        Set daoBeans = this.getBeans(new TypeLiteral<Dao<T2, T3>>(){}, new Annotation[0]);
        Assert.assertEquals((int)daoBeans.size(), (int)1);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(daoBeans.iterator().next().getTypes(), Dao.class, Object.class));
    }
}

