/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.bean;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProducerFactory;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Hungry;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Office;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.SerializableOffice;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Tiger;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.VehicleDecorator;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Zoo;
import org.jboss.cdi.tck.util.ForwardingBeanAttributes;
import org.testng.Assert;

public class BeanExtension
implements Extension {
    private Bean<Zoo> zooBean;

    void registerBeans(@Observes AfterBeanDiscovery event, BeanManager manager) {
        AnnotatedType oat = manager.createAnnotatedType(Office.class);
        BeanAttributes oa = manager.createBeanAttributes(oat);
        InjectionTargetFactory factory = manager.getInjectionTargetFactory(oat);
        Bean bean = manager.createBean(oa, Office.class, factory);
        event.addBean(bean);
        oat = manager.createAnnotatedType(SerializableOffice.class);
        oa = manager.createBeanAttributes(oat);
        factory = manager.getInjectionTargetFactory(oat);
        bean = manager.createBean(oa, SerializableOffice.class, factory);
        event.addBean(bean);
        oat = manager.createAnnotatedType(VehicleDecorator.class);
        oa = this.addDecoratorStereotype(manager.createBeanAttributes(oat));
        factory = manager.getInjectionTargetFactory(oat);
        bean = manager.createBean(oa, VehicleDecorator.class, factory);
        Assert.assertTrue((boolean)(bean instanceof Decorator));
        event.addBean(bean);
        Assert.assertNotNull(this.zooBean);
        AnnotatedType zoo = manager.createAnnotatedType(Zoo.class);
        Assert.assertEquals((int)1, (int)zoo.getFields().size());
        AnnotatedField field = (AnnotatedField)zoo.getFields().iterator().next();
        BeanAttributes attributes = this.starveOut(manager.createBeanAttributes((AnnotatedMember)field));
        ProducerFactory factory2 = manager.getProducerFactory(field, this.zooBean);
        event.addBean(manager.createBean(attributes, Zoo.class, factory2));
        zoo = manager.createAnnotatedType(Zoo.class);
        AnnotatedMethod method = null;
        for (AnnotatedMethod _method : zoo.getMethods()) {
            if (!_method.getBaseType().equals(Tiger.class)) continue;
            method = _method;
        }
        Assert.assertNotNull(method);
        attributes = this.starveOut(manager.createBeanAttributes(method));
        factory2 = manager.getProducerFactory(method, this.zooBean);
        event.addBean(manager.createBean(attributes, Zoo.class, factory2));
    }

    void observeZooBean(@Observes ProcessManagedBean<Zoo> event) {
        this.zooBean = event.getBean();
    }

    private <T> BeanAttributes<T> starveOut(final BeanAttributes<T> attributes) {
        return new ForwardingBeanAttributes<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                HashSet<Hungry.Literal> qualifiers = new HashSet<Hungry.Literal>(attributes.getQualifiers());
                qualifiers.add(Hungry.Literal.INSTANCE);
                qualifiers.remove(DefaultLiteral.INSTANCE);
                return Collections.unmodifiableSet(qualifiers);
            }

            @Override
            protected BeanAttributes<T> attributes() {
                return attributes;
            }
        };
    }

    private <T> BeanAttributes<T> addDecoratorStereotype(final BeanAttributes<T> attributes) {
        return new ForwardingBeanAttributes<T>(){

            @Override
            protected BeanAttributes<T> attributes() {
                return attributes;
            }

            @Override
            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.singleton(javax.decorator.Decorator.class);
            }
        };
    }
}

