/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Bestiary;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Consumer;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Den;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Dragon;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.ExplicitContructorSimpleBean;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Fox;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.FoxRun;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Griffin;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Hippogriff;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.InitializerSimpleBean;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Lion;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.LionCage;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Litter;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.NewLionConsumer;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Order;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.OrderInterceptor;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Shop;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Tame;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.TameLiteral;
import org.jboss.cdi.tck.tests.implementation.simple.newSimpleBean.Tiger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class NewSimpleBeanTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NewSimpleBeanTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Tiger.class.getName()}).up()).createInterceptors().clazz(new String[]{OrderInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="ya")})
    public void testNewBeanCreatedForFieldInjectionPoint() {
        assert (this.getContextualReference(Griffin.class, new Annotation[0]).getList() instanceof ArrayList);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="yc")})
    public void testNewBeanCreatedForInitializerInjectionPoint() {
        assert (this.getContextualReference(Dragon.class, new Annotation[0]).getChildren() instanceof HashSet);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="ye")})
    public void testNewBeanCreatedForConstructorInjectioAnPoint() {
        assert (this.getContextualReference(Hippogriff.class, new Annotation[0]).getHomes() instanceof HashMap);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="yg")})
    public void testNewBeanCreatedForProducerMethod() {
        assert (this.getContextualReference(new TypeLiteral<Collection<Dragon>>(){}, new Annotation[0]) instanceof ArrayList);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="yi")})
    public void testNewBeanCreatedForObserverMethod() {
        this.getCurrentManager().fireEvent((Object)new Griffin(), new Annotation[0]);
        assert (this.getContextualReference(Bestiary.class, new Annotation[0]).getPossibleNames() instanceof TreeSet);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="yk")})
    public void testNewBeanCreatedForDisposerMethod() {
        Bean<Collection<Dragon>> bean = this.getUniqueBean(new TypeLiteral<Collection<Dragon>>(){}, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Collection dragons = (Collection)bean.create(ctx);
        bean.destroy((Object)dragons, ctx);
        assert (this.getContextualReference(Bestiary.class, new Annotation[0]).getKnightsWhichKilledTheDragons() instanceof LinkedHashSet);
    }

    @Test
    @SpecAssertions(value={})
    public void testNewBeanIsDependentScoped() {
        FoxRun foxRun = this.getContextualReference(FoxRun.class, new Annotation[0]);
        foxRun.getNewFox().setDen(new Den("TheLarches"));
        assert (!foxRun.getNewFox().getDen().getName().equals(foxRun.getNewFox2().getDen().getName()));
    }

    @Test
    @SpecAssertion(section="new", id="t")
    public void testNewBeanHasNoStereotypes() {
        Bean<Fox> foxBean = this.getBeans(Fox.class, new Annotation[0]).iterator().next();
        assert (foxBean.getScope().equals(RequestScoped.class));
        assert (foxBean.getName().equals("fox"));
        Fox newFox1 = this.getContextualReference(FoxRun.class, new Annotation[0]).getNewFox();
        Fox newFox2 = this.getContextualReference(FoxRun.class, new Annotation[0]).getNewFox();
        newFox1.setDen(new Den("TheElms"));
        assert (newFox2.getDen().getName() != "TheElms");
    }

    @Test
    @SpecAssertion(section="new", id="u")
    public void testNewBeanHasNoObservers() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)"event", new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertion(section="new", id="w")
    public void testNewBeanHasNoProducerFields() throws Exception {
        FoxRun foxRun = this.getContextualReference(FoxRun.class, new Annotation[0]);
        foxRun.getNewFox().setDen(new Den("NewFoxDen"));
        Den theOnlyDen = this.getContextualReference(Den.class, new Annotation[0]);
        assert (theOnlyDen.getName().equals(foxRun.getFox().getDen().getName()));
    }

    @Test
    @SpecAssertion(section="new", id="v")
    public void testNewBeanHasNoProducerMethods() throws Exception {
        FoxRun foxRun = this.getContextualReference(FoxRun.class, new Annotation[0]);
        foxRun.getFox().setNextLitterSize(3);
        foxRun.getNewFox().setNextLitterSize(5);
        Litter theOnlyLitter = this.getContextualReference(Litter.class, new Annotation[0]);
        assert (theOnlyLitter.getQuantity() == foxRun.getFox().getNextLitterSize());
    }

    @Test
    @SpecAssertion(section="new", id="x")
    public void testNewBeanHasNoDisposerMethods() throws Exception {
        FoxRun foxRun = this.getContextualReference(FoxRun.class, new Annotation[0]);
        Bean<Litter> litterBean = this.getBeans(Litter.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(litterBean);
        Litter litter = this.getContextualReference(Litter.class, new Annotation[0]);
        litterBean.destroy((Object)litter, creationalContext);
        assert (foxRun.getFox().isLitterDisposed());
        assert (!foxRun.getNewFox().isLitterDisposed());
    }

    @Test
    @SpecAssertion(section="new", id="d")
    public void testForEachSimpleBeanANewBeanExists() {
        Bean<Order> orderBean = this.getUniqueBean(Order.class, new Annotation[0]);
        Assert.assertEquals((int)orderBean.getQualifiers().size(), (int)2);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)orderBean.getQualifiers(), Any.class, Default.class));
        Assert.assertNotNull((Object)this.getContextualReference(Shop.class, new Annotation[0]).getNewOrder());
        Bean<Order> newOrderBean = this.getUniqueBean(Order.class, new Annotation[]{NewLiteral.INSTANCE});
        Assert.assertEquals((Object)newOrderBean.getBeanClass(), Order.class);
        Bean<Lion> lionBean = this.getUniqueBean(Lion.class, new Annotation[]{new TameLiteral()});
        Assert.assertEquals((int)lionBean.getQualifiers().size(), (int)2);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)lionBean.getQualifiers(), Any.class, Tame.class));
        Assert.assertNotNull((Object)this.getContextualReference(LionCage.class, new Annotation[0]).getNewLion());
    }

    @Test
    @SpecAssertion(section="new", id="e")
    public void testNewBeanHasTheSameBeanTypes() {
        Bean<Order> bean = this.getUniqueBean(Order.class, new Annotation[]{NewLiteral.INSTANCE});
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Serializable.class, Order.class}));
    }

    @Test
    @SpecAssertion(section="new", id="i")
    public void testNewBeanHasTheSameInterceptorBindings() {
        Assert.assertTrue((boolean)this.getContextualReference(Shop.class, new Annotation[0]).getNewOrder().foo());
    }

    @Test
    @SpecAssertion(section="new", id="f")
    public void testNewBeanHasSameConstructor() {
        ExplicitContructorSimpleBean.setConstructorCalls(0);
        Consumer consumer = this.getContextualReference(Consumer.class, new Annotation[0]);
        consumer.getExplicitConstructorBean().ping();
        consumer.getNewExplicitConstructorBean().ping();
        int calls = ExplicitContructorSimpleBean.getConstructorCalls();
        assert (calls == 2);
    }

    @Test
    @SpecAssertion(section="new", id="g")
    public void testNewBeanHasSameInitializers() {
        InitializerSimpleBean.setInitializerCalls(0);
        Consumer consumer = this.getContextualReference(Consumer.class, new Annotation[0]);
        consumer.getInitializerSimpleBean().businessMethod();
        consumer.getNewInitializerSimpleBean().businessMethod();
        int calls = InitializerSimpleBean.getInitializerCalls();
        assert (calls == 2);
    }

    @Test
    @SpecAssertion(section="new", id="h")
    public void testNewBeanHasSameInjectedFields() {
        Consumer consumer = this.getContextualReference(Consumer.class, new Annotation[0]);
        assert (consumer.getNewInitializerSimpleBean().getOrder() != null);
    }

    @Test
    @SpecAssertion(section="new", id="xb")
    public void testNewBeanIsNotAlternative() {
        assert (this.getUniqueBean(Tiger.class, new Annotation[0]).isAlternative());
        assert (!this.getUniqueBean(Tiger.class, new Annotation[]{NewLiteral.INSTANCE}).isAlternative());
    }

    @Test
    @SpecAssertion(section="new", id="z")
    public void testNewBeanWithNoMemberValue() {
        assert (this.getContextualReference(NewLionConsumer.class, new Annotation[0]).getLion() instanceof Lion);
    }
}

