/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap.descriptors.ejb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.ActivationConfigType;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EnterpriseBeansType;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.MessageDrivenBeanType;

public class EjbJarDescriptorBuilder {
    private List<MessageDriven> messageDrivenBeans;

    public EjbJarDescriptorBuilder messageDrivenBeans(MessageDriven ... beans) {
        if (beans != null && beans.length > 0) {
            this.messageDrivenBeans = Arrays.asList(beans);
        }
        return this;
    }

    public EjbJarDescriptor build() {
        EjbJarDescriptor ejbJarDescriptor = (EjbJarDescriptor)Descriptors.create(EjbJarDescriptor.class);
        EnterpriseBeansType enterpriseBeansType = ejbJarDescriptor.getOrCreateEnterpriseBeans();
        if (this.messageDrivenBeans != null && !this.messageDrivenBeans.isEmpty()) {
            for (MessageDriven messageDriven : this.messageDrivenBeans) {
                MessageDrivenBeanType messageDrivenBeanType = enterpriseBeansType.createMessageDriven();
                messageDrivenBeanType.ejbClass(messageDriven.getEjbClass());
                messageDrivenBeanType.ejbName(messageDriven.getEjbName());
                ActivationConfigType activationConfig = messageDrivenBeanType.getOrCreateActivationConfig();
                for (ActivationConfigProperty activationConfigProperty : messageDriven.getActivationConfigProperties()) {
                    activationConfig.createActivationConfigProperty().activationConfigPropertyName(activationConfigProperty.getName()).activationConfigPropertyValue(activationConfigProperty.getValue());
                }
            }
        }
        return ejbJarDescriptor;
    }

    public static class ActivationConfigProperty {
        private String name;
        private String value;

        public ActivationConfigProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MessageDriven {
        private String ejbName;
        private String ejbClass;
        private List<ActivationConfigProperty> activationConfigProperties = new ArrayList<ActivationConfigProperty>();

        public MessageDriven(String ejbName, String ejbClass) {
            this.ejbName = ejbName;
            this.ejbClass = ejbClass;
        }

        public MessageDriven addActivationConfigProperty(String name, String value) {
            this.activationConfigProperties.add(new ActivationConfigProperty(name, value));
            return this;
        }

        public String getEjbName() {
            return this.ejbName;
        }

        public String getEjbClass() {
            return this.ejbClass;
        }

        public List<ActivationConfigProperty> getActivationConfigProperties() {
            return this.activationConfigProperties;
        }

        public static MessageDriven newMessageDriven(String ejbName, String ejbClass) {
            return new MessageDriven(ejbName, ejbClass);
        }
    }
}

